/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.zalando.nakadi.metrics.MetricUtils;

public class EventTypeMetrics {
    private final String eventTypeName;
    private final MetricRegistry metricRegistry;
    private final Histogram eventsPerBatchHistogram;
    private final Timer publishingTimer;
    private final Meter eventCountMeter;
    private final Histogram averageEventSizeInBytesHistogram;
    private final ConcurrentMap<Integer, Meter> statusCodeMeter = new ConcurrentHashMap<Integer, Meter>();

    public EventTypeMetrics(String eventTypeName, MetricRegistry metricRegistry) {
        this.eventTypeName = eventTypeName;
        this.metricRegistry = metricRegistry;
        this.eventCountMeter = metricRegistry.meter(MetricUtils.metricNameFor(eventTypeName, "publishing.events"));
        this.eventsPerBatchHistogram = metricRegistry.histogram(MetricUtils.metricNameFor(eventTypeName, "publishing.eventsPerBatch"));
        this.averageEventSizeInBytesHistogram = metricRegistry.histogram(MetricUtils.metricNameFor(eventTypeName, "publishing.averageEventSizeInBytes"));
        this.publishingTimer = metricRegistry.timer(MetricUtils.metricNameFor(eventTypeName, "publishing"));
    }

    public void reportSizing(int eventsPerBatch, int totalEventSize) {
        this.eventsPerBatchHistogram.update(eventsPerBatch);
        this.eventCountMeter.mark((long)eventsPerBatch);
        this.averageEventSizeInBytesHistogram.update(eventsPerBatch == 0 ? 0 : totalEventSize / eventsPerBatch);
    }

    public void incrementResponseCount(int code) {
        this.statusCodeMeter.computeIfAbsent(code, key -> this.metricRegistry.meter(MetricUtils.metricNameFor(this.eventTypeName, "publishing." + code))).mark();
    }

    public void updateTiming(long startingNanos, long currentNanos) {
        this.publishingTimer.update(currentNanos - startingNanos, TimeUnit.NANOSECONDS);
    }

    @VisibleForTesting
    public long getResponseCount(int code) {
        return Optional.ofNullable(this.statusCodeMeter.get(code)).map(Meter::getCount).orElse(-1L);
    }
}

