/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.partitioning;

import java.util.List;
import org.json.JSONObject;
import org.zalando.nakadi.domain.EventCategory;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.exceptions.ExceptionWrapper;
import org.zalando.nakadi.exceptions.InvalidPartitionKeyFieldsException;
import org.zalando.nakadi.partitioning.PartitionStrategy;
import org.zalando.nakadi.util.JsonPathAccess;

public class HashPartitionStrategy
implements PartitionStrategy {
    private static final String DATA_PATH_PREFIX = "data.";

    @Override
    public String calculatePartition(EventType eventType, JSONObject event, List<String> partitions) throws InvalidPartitionKeyFieldsException {
        List<String> partitionKeyFields = eventType.getPartitionKeyFields();
        if (partitionKeyFields.isEmpty()) {
            throw new RuntimeException("Applying " + this.getClass().getSimpleName() + " although event type has no partition key fields configured.");
        }
        try {
            JsonPathAccess traversableJsonEvent = new JsonPathAccess(event);
            int hashValue = partitionKeyFields.stream().map(pkf -> EventCategory.DATA.equals((Object)eventType.getCategory()) ? DATA_PATH_PREFIX + pkf : pkf).map(ExceptionWrapper.wrapFunction(okf -> traversableJsonEvent.get((String)okf).toString().hashCode())).mapToInt(hc -> hc).sum();
            int partitionIndex = Math.abs(hashValue) % partitions.size();
            return partitions.get(partitionIndex);
        }
        catch (ExceptionWrapper e) {
            Exception original = e.getWrapped();
            if (original instanceof InvalidPartitionKeyFieldsException) {
                throw (InvalidPartitionKeyFieldsException)original;
            }
            throw e;
        }
    }
}

