/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.partitioning;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.domain.EventCategory;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.exceptions.InvalidEventTypeException;
import org.zalando.nakadi.exceptions.NoSuchPartitionStrategyException;
import org.zalando.nakadi.exceptions.PartitioningException;
import org.zalando.nakadi.partitioning.HashPartitionStrategy;
import org.zalando.nakadi.partitioning.PartitionStrategy;
import org.zalando.nakadi.partitioning.RandomPartitionStrategy;
import org.zalando.nakadi.partitioning.UserDefinedPartitionStrategy;
import org.zalando.nakadi.repository.TopicRepository;

@Component
public class PartitionResolver {
    private static final Map<String, PartitionStrategy> PARTITION_STRATEGIES = ImmutableMap.of((Object)"hash", (Object)new HashPartitionStrategy(), (Object)"user_defined", (Object)new UserDefinedPartitionStrategy(), (Object)"random", (Object)new RandomPartitionStrategy(new Random()));
    public static final List<String> ALL_PARTITION_STRATEGIES = Lists.newArrayList(PARTITION_STRATEGIES.keySet());
    private final TopicRepository topicRepository;

    @Autowired
    public PartitionResolver(TopicRepository topicRepository) {
        this.topicRepository = topicRepository;
    }

    public void validate(EventType eventType) throws NoSuchPartitionStrategyException, InvalidEventTypeException {
        String partitionStrategy = eventType.getPartitionStrategy();
        if (!ALL_PARTITION_STRATEGIES.contains(partitionStrategy)) {
            throw new NoSuchPartitionStrategyException("partition strategy does not exist: " + partitionStrategy);
        }
        if ("hash".equals(partitionStrategy) && eventType.getPartitionKeyFields().isEmpty()) {
            throw new InvalidEventTypeException("partition_key_fields field should be set for partition strategy 'hash'");
        }
        if ("user_defined".equals(partitionStrategy) && EventCategory.UNDEFINED.equals((Object)eventType.getCategory())) {
            throw new InvalidEventTypeException("'user_defined' partition strategy can't be used for EventType of category 'undefined'");
        }
    }

    public String resolvePartition(EventType eventType, JSONObject eventAsJson) throws PartitioningException {
        String eventTypeStrategy = eventType.getPartitionStrategy();
        PartitionStrategy partitionStrategy = PARTITION_STRATEGIES.get(eventTypeStrategy);
        if (partitionStrategy == null) {
            throw new PartitioningException("Partition Strategy defined for this EventType is not found: " + eventTypeStrategy);
        }
        List<String> partitions = this.topicRepository.listPartitionNames(eventType.getTopic());
        return partitionStrategy.calculatePartition(eventType, eventAsJson, partitions);
    }
}

