/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.validation.EventTypeValidator;
import org.zalando.nakadi.validation.EventValidation;

public class EventTypeCache {
    public static final String ZKNODE_PATH = "/nakadi/event_types";
    public static final int CACHE_MAX_SIZE = 100000;
    private final LoadingCache<String, EventType> eventTypeCache;
    private final LoadingCache<String, EventTypeValidator> validatorCache;
    private final PathChildrenCache cacheSync;
    private final CuratorFramework zkClient;

    public EventTypeCache(EventTypeRepository eventTypeRepository, CuratorFramework zkClient) throws Exception {
        this.initParentCacheZNode(zkClient);
        this.zkClient = zkClient;
        this.eventTypeCache = this.setupInMemoryEventTypeCache(eventTypeRepository);
        this.validatorCache = this.setupInMemoryValidatorCache(this.eventTypeCache);
        this.cacheSync = this.setupCacheSync(zkClient);
    }

    public void updated(String name) throws Exception {
        String path = this.getZNodePath(name);
        this.created(name);
        this.zkClient.setData().forPath(path, new byte[0]);
    }

    public EventType getEventType(String name) throws NoSuchEventTypeException, InternalNakadiException {
        try {
            return (EventType)this.eventTypeCache.get((Object)name);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoSuchEventTypeException) {
                NoSuchEventTypeException noSuchEventTypeException = (NoSuchEventTypeException)e.getCause();
                throw noSuchEventTypeException;
            }
            throw new InternalNakadiException("Problem loading event type", e);
        }
    }

    public EventTypeValidator getValidator(String name) throws ExecutionException {
        return (EventTypeValidator)this.validatorCache.get((Object)name);
    }

    public void created(String name) throws Exception {
        try {
            String path = this.getZNodePath(name);
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, new byte[0]);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    public void removed(String name) throws Exception {
        String path = this.getZNodePath(name);
        this.created(name);
        this.zkClient.delete().forPath(path);
    }

    private void initParentCacheZNode(CuratorFramework zkClient) throws Exception {
        try {
            ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ZKNODE_PATH);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    private void addCacheChangeListener(final LoadingCache<String, EventType> eventTypeCache, final LoadingCache<String, EventTypeValidator> validatorCache, PathChildrenCache cacheSync) {
        PathChildrenCacheListener listener = new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                if (event.getType() == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                    this.invalidateCacheKey(event);
                } else if (event.getType() == PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                    this.invalidateCacheKey(event);
                }
            }

            private void invalidateCacheKey(PathChildrenCacheEvent event) {
                String[] path = event.getData().getPath().split("/");
                String key = path[path.length - 1];
                validatorCache.invalidate((Object)key);
                eventTypeCache.invalidate((Object)key);
            }
        };
        cacheSync.getListenable().addListener((Object)listener);
    }

    private PathChildrenCache setupCacheSync(CuratorFramework zkClient) throws Exception {
        PathChildrenCache cacheSync = new PathChildrenCache(zkClient, ZKNODE_PATH, false);
        cacheSync.start();
        this.addCacheChangeListener(this.eventTypeCache, this.validatorCache, cacheSync);
        return cacheSync;
    }

    private LoadingCache<String, EventTypeValidator> setupInMemoryValidatorCache(final LoadingCache<String, EventType> eventTypeCache) {
        CacheLoader<String, EventTypeValidator> loader = new CacheLoader<String, EventTypeValidator>(){

            public EventTypeValidator load(String key) throws Exception {
                EventType et = (EventType)eventTypeCache.get((Object)key);
                return EventValidation.forType(et);
            }
        };
        return CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)loader);
    }

    private LoadingCache<String, EventType> setupInMemoryEventTypeCache(final EventTypeRepository eventTypeRepository) {
        CacheLoader<String, EventType> loader = new CacheLoader<String, EventType>(){

            public EventType load(String key) throws Exception {
                EventType eventType = eventTypeRepository.findByName(key);
                EventTypeCache.this.created(key);
                return eventType;
            }
        };
        return CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)loader);
    }

    private String getZNodePath(String eventTypeName) {
        return ZKPaths.makePath((String)ZKNODE_PATH, (String)eventTypeName);
    }
}

