/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.kafka;

import javax.annotation.concurrent.Immutable;
import org.zalando.nakadi.domain.Cursor;

@Immutable
class KafkaCursor {
    private final int partition;
    private final long offset;

    private KafkaCursor(int partition, long offset) {
        this.partition = partition;
        this.offset = offset;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public Cursor asNakadiCursor() {
        return new Cursor(KafkaCursor.toNakadiPartition(this.partition), KafkaCursor.toNakadiOffset(this.offset));
    }

    public static KafkaCursor fromNakadiCursor(Cursor cursor) {
        return KafkaCursor.kafkaCursor(cursor.getPartition(), cursor.getOffset());
    }

    public static KafkaCursor kafkaCursor(int partition, long offset) {
        return new KafkaCursor(partition, offset);
    }

    public static KafkaCursor kafkaCursor(String partition, String offset) {
        return new KafkaCursor(KafkaCursor.toKafkaPartition(partition), KafkaCursor.toKafkaOffset(offset));
    }

    public static int toKafkaPartition(String partition) {
        return Integer.parseInt(partition);
    }

    public static String toNakadiPartition(int partition) {
        return Integer.toString(partition);
    }

    public static long toKafkaOffset(String offest) {
        return Long.parseLong(offest);
    }

    public static String toNakadiOffset(long offset) {
        return Long.toString(offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaCursor that = (KafkaCursor)o;
        return this.partition == that.partition && this.offset == that.offset;
    }

    public int hashCode() {
        int result = this.partition;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public String toString() {
        return "KafkaCursor{partition=" + this.partition + ", offset=" + this.offset + '}';
    }
}

