/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.kafka;

import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.repository.kafka.KafkaCursor;
import org.zalando.nakadi.repository.kafka.KafkaLocationManager;
import org.zalando.nakadi.repository.kafka.NakadiKafkaConsumer;

@Component
@Profile(value={"!test"})
public class KafkaFactory {
    private final KafkaLocationManager kafkaLocationManager;
    private final KafkaProducer<String, String> kafkaProducer;

    @Autowired
    public KafkaFactory(KafkaLocationManager kafkaLocationManager) {
        this.kafkaLocationManager = kafkaLocationManager;
        this.kafkaProducer = new KafkaProducer(kafkaLocationManager.getKafkaProducerProperties());
    }

    public Producer<String, String> getProducer() {
        return this.kafkaProducer;
    }

    public Consumer<String, String> getConsumer() {
        return new KafkaConsumer(this.kafkaLocationManager.getKafkaProperties());
    }

    public NakadiKafkaConsumer createNakadiConsumer(String topic, List<KafkaCursor> kafkaCursors, long pollTimeout) {
        return new NakadiKafkaConsumer(this.getConsumer(), topic, kafkaCursors, pollTimeout);
    }
}

