/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.kafka;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KafkaRepositorySettings {
    private final int maxTopicPartitionCount;
    private final int defaultTopicPartitionCount;
    private final int defaultTopicReplicaFactor;
    private final long defaultTopicRetentionMs;
    private final long defaultTopicRotationMs;
    private final long kafkaPollTimeoutMs;
    private final long kafkaSendTimeoutMs;
    private final int zkSessionTimeoutMs;
    private final int zkConnectionTimeoutMs;

    @Autowired
    public KafkaRepositorySettings(@Value(value="${nakadi.topic.max.partitionNum}") int maxTopicPartitionCount, @Value(value="${nakadi.topic.default.partitionNum}") int defaultTopicPartitionCount, @Value(value="${nakadi.topic.default.replicaFactor}") int defaultTopicReplicaFactor, @Value(value="${nakadi.topic.default.retentionMs}") long defaultTopicRetentionMs, @Value(value="${nakadi.topic.default.rotationMs}") long defaultTopicRotationMs, @Value(value="${nakadi.kafka.poll.timeoutMs}") long kafkaPollTimeoutMs, @Value(value="${nakadi.kafka.send.timeoutMs}") long kafkaSendTimeoutMs, @Value(value="${nakadi.zookeeper.sessionTimeoutMs}") int zkSessionTimeoutMs, @Value(value="${nakadi.zookeeper.connectionTimeoutMs}") int zkConnectionTimeoutMs) {
        this.maxTopicPartitionCount = maxTopicPartitionCount;
        this.defaultTopicPartitionCount = defaultTopicPartitionCount;
        this.defaultTopicReplicaFactor = defaultTopicReplicaFactor;
        this.defaultTopicRetentionMs = defaultTopicRetentionMs;
        this.defaultTopicRotationMs = defaultTopicRotationMs;
        this.kafkaPollTimeoutMs = kafkaPollTimeoutMs;
        this.kafkaSendTimeoutMs = kafkaSendTimeoutMs;
        this.zkSessionTimeoutMs = zkSessionTimeoutMs;
        this.zkConnectionTimeoutMs = zkConnectionTimeoutMs;
    }

    public int getDefaultTopicPartitionCount() {
        return this.defaultTopicPartitionCount;
    }

    public int getMaxTopicPartitionCount() {
        return this.maxTopicPartitionCount;
    }

    public int getDefaultTopicReplicaFactor() {
        return this.defaultTopicReplicaFactor;
    }

    public long getDefaultTopicRetentionMs() {
        return this.defaultTopicRetentionMs;
    }

    public long getDefaultTopicRotationMs() {
        return this.defaultTopicRotationMs;
    }

    public long getKafkaPollTimeoutMs() {
        return this.kafkaPollTimeoutMs;
    }

    public long getKafkaSendTimeoutMs() {
        return this.kafkaSendTimeoutMs;
    }

    public int getZkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public int getZkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }
}

