/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.security;

import java.security.Principal;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedUserException;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.zalando.nakadi.config.SecuritySettings;
import org.zalando.nakadi.security.Client;
import org.zalando.nakadi.util.FeatureToggleService;

@Component
public class ClientResolver
implements HandlerMethodArgumentResolver {
    private final SecuritySettings settings;
    private final FeatureToggleService featureToggleService;

    @Autowired
    public ClientResolver(SecuritySettings settings, FeatureToggleService featureToggleService) {
        this.settings = settings;
        this.featureToggleService = featureToggleService;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isAssignableFrom(Client.class);
    }

    public Client resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        Optional<String> clientId;
        block3: {
            block2: {
                clientId = Optional.ofNullable(request.getUserPrincipal()).map(Principal::getName);
                if (!this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.CHECK_APPLICATION_LEVEL_PERMISSIONS)) break block2;
                if (!clientId.filter(this.settings.getAdminClientId()::equals).isPresent() && this.settings.getAuthMode() != SecuritySettings.AuthMode.OFF) break block3;
            }
            return Client.PERMIT_ALL;
        }
        return clientId.map(Client.Authorized::new).orElseThrow(() -> new UnauthorizedUserException("Client unauthorized"));
    }
}

