/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service;

import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.domain.Cursor;
import org.zalando.nakadi.domain.CursorError;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.Subscription;
import org.zalando.nakadi.exceptions.InvalidCursorException;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.NoSuchSubscriptionException;
import org.zalando.nakadi.exceptions.ServiceUnavailableException;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.TopicRepository;
import org.zalando.nakadi.repository.db.SubscriptionDbRepository;
import org.zalando.nakadi.repository.zookeeper.ZooKeeperHolder;
import org.zalando.nakadi.repository.zookeeper.ZooKeeperLockFactory;
import org.zalando.nakadi.repository.zookeeper.ZookeeperUtils;
import org.zalando.nakadi.service.subscription.KafkaClient;
import org.zalando.nakadi.service.subscription.SubscriptionKafkaClientFactory;
import org.zalando.nakadi.service.subscription.model.Partition;
import org.zalando.nakadi.service.subscription.zk.ZkSubscriptionClient;
import org.zalando.nakadi.service.subscription.zk.ZkSubscriptionClientFactory;

@Component
public class CursorsService {
    private static final Logger LOG = LoggerFactory.getLogger(CursorsService.class);
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final String PATH_ZK_OFFSET = "/nakadi/subscriptions/{0}/topics/{1}/{2}/offset";
    private static final String PATH_ZK_PARTITIONS = "/nakadi/subscriptions/{0}/topics/{1}";
    private static final String ERROR_COMMUNICATING_WITH_ZOOKEEPER = "Error communicating with zookeeper";
    private final ZooKeeperHolder zkHolder;
    private final TopicRepository topicRepository;
    private final SubscriptionDbRepository subscriptionRepository;
    private final EventTypeRepository eventTypeRepository;
    private final ZooKeeperLockFactory zkLockFactory;
    private final ZkSubscriptionClientFactory zkSubscriptionClientFactory;
    private final SubscriptionKafkaClientFactory subscriptionKafkaClientFactory;

    @Autowired
    public CursorsService(ZooKeeperHolder zkHolder, TopicRepository topicRepository, SubscriptionDbRepository subscriptionRepository, EventTypeRepository eventTypeRepository, ZooKeeperLockFactory zkLockFactory, ZkSubscriptionClientFactory zkSubscriptionClientFactory, SubscriptionKafkaClientFactory subscriptionKafkaClientFactory) {
        this.zkHolder = zkHolder;
        this.topicRepository = topicRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.eventTypeRepository = eventTypeRepository;
        this.zkLockFactory = zkLockFactory;
        this.zkSubscriptionClientFactory = zkSubscriptionClientFactory;
        this.subscriptionKafkaClientFactory = subscriptionKafkaClientFactory;
    }

    public boolean commitCursors(String subscriptionId, List<Cursor> cursors) throws NakadiException, InvalidCursorException {
        Subscription subscription = this.subscriptionRepository.getSubscription(subscriptionId);
        String eventTypeName = subscription.getEventTypes().iterator().next();
        EventType eventType = this.eventTypeRepository.findByName(eventTypeName);
        this.createSubscriptionInZkIfNeeded(subscription);
        this.topicRepository.validateCommitCursors(eventType.getTopic(), cursors);
        boolean allCommitted = true;
        for (Cursor cursor : cursors) {
            boolean cursorCommitted = this.commitCursor(subscriptionId, eventType.getTopic(), cursor);
            allCommitted = allCommitted && cursorCommitted;
        }
        return allCommitted;
    }

    private boolean commitCursor(String subscriptionId, String eventType, Cursor cursor) throws ServiceUnavailableException, NoSuchSubscriptionException, InvalidCursorException {
        String offsetPath = MessageFormat.format(PATH_ZK_OFFSET, subscriptionId, eventType, cursor.getPartition());
        try {
            return ZookeeperUtils.runLocked(() -> {
                String currentOffset = new String((byte[])this.zkHolder.get().getData().forPath(offsetPath), CHARSET_UTF8);
                if (this.topicRepository.compareOffsets(cursor.getOffset(), currentOffset) > 0) {
                    this.zkHolder.get().setData().forPath(offsetPath, cursor.getOffset().getBytes(CHARSET_UTF8));
                    return true;
                }
                return false;
            }, this.zkLockFactory.createLock(offsetPath));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCursorException(CursorError.INVALID_FORMAT, cursor);
        }
        catch (Exception e) {
            throw new ServiceUnavailableException(ERROR_COMMUNICATING_WITH_ZOOKEEPER, e);
        }
    }

    private void createSubscriptionInZkIfNeeded(Subscription subscription) throws ServiceUnavailableException {
        ZkSubscriptionClient subscriptionClient = this.zkSubscriptionClientFactory.createZkSubscriptionClient(subscription.getId());
        AtomicReference<Exception> atomicReference = new AtomicReference<Exception>();
        try {
            if (!subscriptionClient.isSubscriptionCreated()) {
                subscriptionClient.runLocked(() -> {
                    try {
                        if (!subscriptionClient.isSubscriptionCreated() && subscriptionClient.createSubscription()) {
                            KafkaClient kafkaClient = this.subscriptionKafkaClientFactory.createKafkaClient(subscription);
                            Map<Partition.PartitionKey, Long> subscriptionOffsets = kafkaClient.getSubscriptionOffsets();
                            subscriptionClient.fillEmptySubscription(subscriptionOffsets);
                        }
                    }
                    catch (Exception e) {
                        atomicReference.set(e);
                    }
                });
            }
        }
        catch (Exception e) {
            atomicReference.set(e);
        }
        if (atomicReference.get() != null) {
            throw new ServiceUnavailableException(ERROR_COMMUNICATING_WITH_ZOOKEEPER, (Exception)atomicReference.get());
        }
    }

    public List<Cursor> getSubscriptionCursors(String subscriptionId) throws NakadiException {
        Subscription subscription = this.subscriptionRepository.getSubscription(subscriptionId);
        String eventTypeName = subscription.getEventTypes().iterator().next();
        String topic = this.eventTypeRepository.findByName(eventTypeName).getTopic();
        String partitionsPath = MessageFormat.format(PATH_ZK_PARTITIONS, subscriptionId, topic);
        try {
            return ((List)this.zkHolder.get().getChildren().forPath(partitionsPath)).stream().map(partition -> this.readCursor(subscriptionId, topic, (String)partition)).collect(Collectors.toList());
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.debug(nne.getMessage(), (Throwable)nne);
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new ServiceUnavailableException(ERROR_COMMUNICATING_WITH_ZOOKEEPER, e);
        }
    }

    private Cursor readCursor(String subscriptionId, String topic, String partition) throws RuntimeException {
        try {
            String offsetPath = MessageFormat.format(PATH_ZK_OFFSET, subscriptionId, topic, partition);
            String currentOffset = new String((byte[])this.zkHolder.get().getData().forPath(offsetPath), CHARSET_UTF8);
            return new Cursor(partition, currentOffset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

