/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.domain.BatchFactory;
import org.zalando.nakadi.domain.BatchItem;
import org.zalando.nakadi.domain.BatchItemResponse;
import org.zalando.nakadi.domain.EventPublishResult;
import org.zalando.nakadi.domain.EventPublishingStatus;
import org.zalando.nakadi.domain.EventPublishingStep;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.enrichment.Enrichment;
import org.zalando.nakadi.exceptions.EnrichmentException;
import org.zalando.nakadi.exceptions.EventPublishingException;
import org.zalando.nakadi.exceptions.EventValidationException;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.exceptions.PartitioningException;
import org.zalando.nakadi.partitioning.PartitionResolver;
import org.zalando.nakadi.repository.TopicRepository;
import org.zalando.nakadi.repository.db.EventTypeCache;
import org.zalando.nakadi.validation.EventTypeValidator;
import org.zalando.nakadi.validation.ValidationError;

@Component
public class EventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(EventPublisher.class);
    private final TopicRepository topicRepository;
    private final EventTypeCache eventTypeCache;
    private final PartitionResolver partitionResolver;
    private final Enrichment enrichment;

    @Autowired
    public EventPublisher(TopicRepository topicRepository, EventTypeCache eventTypeCache, PartitionResolver partitionResolver, Enrichment enrichment) {
        this.topicRepository = topicRepository;
        this.eventTypeCache = eventTypeCache;
        this.partitionResolver = partitionResolver;
        this.enrichment = enrichment;
    }

    public EventPublishResult publish(JSONArray events, String eventTypeName) throws NoSuchEventTypeException, InternalNakadiException {
        EventType eventType = this.eventTypeCache.getEventType(eventTypeName);
        List<BatchItem> batch = BatchFactory.from(events);
        try {
            this.validate(batch, eventType);
            this.partition(batch, eventType);
            this.enrich(batch, eventType);
            this.submit(batch, eventType);
            return this.ok(batch);
        }
        catch (EventValidationException e) {
            LOG.debug("Event validation error: {}", (Object)e.getMessage());
            return this.aborted(EventPublishingStep.VALIDATING, batch);
        }
        catch (PartitioningException e) {
            LOG.debug("Event partition error: {}", (Object)e.getMessage());
            return this.aborted(EventPublishingStep.PARTITIONING, batch);
        }
        catch (EnrichmentException e) {
            LOG.debug("Event enrichment error: {}", (Object)e.getMessage());
            return this.aborted(EventPublishingStep.ENRICHING, batch);
        }
        catch (EventPublishingException e) {
            LOG.error("error publishing event", (Throwable)e);
            return this.failed(batch);
        }
    }

    private void enrich(List<BatchItem> batch, EventType eventType) throws EnrichmentException {
        for (BatchItem batchItem : batch) {
            try {
                batchItem.setStep(EventPublishingStep.ENRICHING);
                this.enrichment.enrich(batchItem, eventType);
            }
            catch (EnrichmentException e) {
                batchItem.updateStatusAndDetail(EventPublishingStatus.FAILED, e.getMessage());
                throw e;
            }
        }
    }

    private List<BatchItemResponse> responses(List<BatchItem> batch) {
        return batch.stream().map(BatchItem::getResponse).collect(Collectors.toList());
    }

    private void partition(List<BatchItem> batch, EventType eventType) throws PartitioningException {
        for (BatchItem item : batch) {
            item.setStep(EventPublishingStep.PARTITIONING);
            try {
                String partitionId = this.partitionResolver.resolvePartition(eventType, item.getEvent());
                item.setPartition(partitionId);
            }
            catch (PartitioningException e) {
                item.updateStatusAndDetail(EventPublishingStatus.FAILED, e.getMessage());
                throw e;
            }
        }
    }

    private void validate(List<BatchItem> batch, EventType eventType) throws EventValidationException, InternalNakadiException {
        for (BatchItem item : batch) {
            item.setStep(EventPublishingStep.VALIDATING);
            try {
                this.validateSchema(item.getEvent(), eventType);
            }
            catch (EventValidationException e) {
                item.updateStatusAndDetail(EventPublishingStatus.FAILED, e.getMessage());
                throw e;
            }
        }
    }

    private void submit(List<BatchItem> batch, EventType eventType) throws EventPublishingException {
        this.topicRepository.syncPostBatch(eventType.getTopic(), batch);
    }

    private void validateSchema(JSONObject event, EventType eventType) throws EventValidationException, InternalNakadiException {
        try {
            EventTypeValidator validator = this.eventTypeCache.getValidator(eventType.getName());
            Optional<ValidationError> validationError = validator.validate(event);
            if (validationError.isPresent()) {
                throw new EventValidationException(validationError.get());
            }
        }
        catch (ExecutionException e) {
            throw new InternalNakadiException("Error loading validator", e);
        }
    }

    private EventPublishResult failed(List<BatchItem> batch) {
        return new EventPublishResult(EventPublishingStatus.FAILED, EventPublishingStep.PUBLISHING, this.responses(batch));
    }

    private EventPublishResult aborted(EventPublishingStep step, List<BatchItem> batch) {
        return new EventPublishResult(EventPublishingStatus.ABORTED, step, this.responses(batch));
    }

    private EventPublishResult ok(List<BatchItem> batch) {
        return new EventPublishResult(EventPublishingStatus.SUBMITTED, EventPublishingStep.NONE, this.responses(batch));
    }
}

