/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.state;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.zalando.nakadi.service.subscription.model.Partition;
import org.zalando.nakadi.service.subscription.state.CleanupState;
import org.zalando.nakadi.service.subscription.state.State;
import org.zalando.nakadi.service.subscription.zk.ZKSubscription;

class ClosingState
extends State {
    private final Map<Partition.PartitionKey, Long> uncommitedOffsets;
    private final Map<Partition.PartitionKey, ZKSubscription> listeners = new HashMap<Partition.PartitionKey, ZKSubscription>();
    private final long lastCommitMillis;
    private ZKSubscription topologyListener;

    ClosingState(Map<Partition.PartitionKey, Long> uncommitedOffsets, long lastCommitMillis) {
        this.uncommitedOffsets = uncommitedOffsets;
        this.lastCommitMillis = lastCommitMillis;
    }

    @Override
    public void onExit() {
        try {
            this.freePartitions(new HashSet<Partition.PartitionKey>(this.listeners.keySet()));
        }
        finally {
            if (null != this.topologyListener) {
                try {
                    this.topologyListener.cancel();
                }
                finally {
                    this.topologyListener = null;
                }
            }
        }
    }

    @Override
    public void onEnter() {
        long timeToWaitMillis = this.getParameters().commitTimeoutMillis - (System.currentTimeMillis() - this.lastCommitMillis);
        if (timeToWaitMillis > 0L) {
            this.scheduleTask(() -> this.switchState(new CleanupState()), timeToWaitMillis, TimeUnit.MILLISECONDS);
            this.topologyListener = this.getZk().subscribeForTopologyChanges(() -> this.addTask(this::onTopologyChanged));
            this.reactOnTopologyChange();
        } else {
            this.switchState(new CleanupState());
        }
    }

    private void onTopologyChanged() {
        if (this.topologyListener == null) {
            throw new IllegalStateException("topologyListener should not be null when calling onTopologyChanged method");
        }
        this.topologyListener.refresh();
        this.reactOnTopologyChange();
    }

    private void reactOnTopologyChange() {
        HashMap partitions = new HashMap();
        this.getZk().runLocked(() -> Stream.of(this.getZk().listPartitions()).filter(p -> this.getSessionId().equals(p.getSession())).forEach(p -> partitions.put(p.getKey(), p)));
        HashSet<Partition.PartitionKey> freeRightNow = new HashSet<Partition.PartitionKey>();
        HashSet<Partition.PartitionKey> addListeners = new HashSet<Partition.PartitionKey>();
        for (Partition p2 : partitions.values()) {
            if (Partition.State.REASSIGNING.equals((Object)p2.getState())) {
                if (!this.uncommitedOffsets.containsKey(p2.getKey())) {
                    freeRightNow.add(p2.getKey());
                    continue;
                }
                if (this.listeners.containsKey(p2.getKey())) continue;
                addListeners.add(p2.getKey());
                continue;
            }
            if (!this.uncommitedOffsets.containsKey(p2.getKey()) || this.listeners.containsKey(p2.getKey())) continue;
            addListeners.add(p2.getKey());
        }
        this.uncommitedOffsets.keySet().stream().filter(p -> !partitions.containsKey(p)).forEach(freeRightNow::add);
        this.freePartitions(freeRightNow);
        addListeners.forEach(this::registerListener);
        this.tryCompleteState();
    }

    private void registerListener(Partition.PartitionKey key) {
        this.listeners.put(key, this.getZk().subscribeForOffsetChanges(key, () -> this.addTask(() -> this.offsetChanged(key))));
        this.reactOnOffset(key);
    }

    private void offsetChanged(Partition.PartitionKey key) {
        if (this.listeners.containsKey(key)) {
            this.listeners.get(key).refresh();
        }
        this.reactOnOffset(key);
    }

    private void reactOnOffset(Partition.PartitionKey key) {
        long newOffset = this.getZk().getOffset(key);
        if (this.uncommitedOffsets.containsKey(key) && this.uncommitedOffsets.get(key) <= newOffset) {
            this.freePartitions(Collections.singletonList(key));
        }
        this.tryCompleteState();
    }

    private void tryCompleteState() {
        if (this.uncommitedOffsets.isEmpty()) {
            this.switchState(new CleanupState());
        }
    }

    private void freePartitions(Collection<Partition.PartitionKey> keys) {
        RuntimeException exceptionCaught = null;
        for (Partition.PartitionKey partitionKey : keys) {
            this.uncommitedOffsets.remove(partitionKey);
            ZKSubscription listener = this.listeners.remove(partitionKey);
            if (null == listener) continue;
            try {
                listener.cancel();
            }
            catch (RuntimeException ex) {
                exceptionCaught = ex;
                this.getLog().error("Failed to cancel offsets listener {}", (Object)listener, (Object)ex);
            }
        }
        this.getZk().runLocked(() -> this.getZk().transfer(this.getSessionId(), keys));
        if (null != exceptionCaught) {
            throw exceptionCaught;
        }
    }
}

