/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.state;

import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadi.service.subscription.zk.ZKSubscription;

class PartitionData {
    private final ZKSubscription subscription;
    private final NavigableMap<Long, String> nakadiEvents = new TreeMap<Long, String>();
    private final Logger log;
    private long commitOffset;
    private long sentOffset;
    private long lastSendMillis;
    private int keepAliveInARow;

    PartitionData(ZKSubscription subscription, Long commitOffset) {
        this(subscription, commitOffset, LoggerFactory.getLogger(PartitionData.class));
    }

    PartitionData(ZKSubscription subscription, Long commitOffset, Logger log) {
        this.subscription = subscription;
        this.log = log;
        this.commitOffset = commitOffset;
        this.sentOffset = commitOffset;
        this.lastSendMillis = System.currentTimeMillis();
    }

    @Nullable
    SortedMap<Long, String> takeEventsToStream(long currentTimeMillis, int batchSize, long batchTimeoutMillis) {
        boolean timeReached;
        boolean countReached = this.nakadiEvents.size() >= batchSize && batchSize > 0;
        boolean bl = timeReached = currentTimeMillis - this.lastSendMillis >= batchTimeoutMillis;
        if (countReached || timeReached) {
            this.lastSendMillis = currentTimeMillis;
            return this.extract(batchSize);
        }
        return null;
    }

    long getSentOffset() {
        return this.sentOffset;
    }

    long getLastSendMillis() {
        return this.lastSendMillis;
    }

    private SortedMap<Long, String> extract(int count) {
        TreeMap<Long, String> result = new TreeMap<Long, String>();
        for (int i = 0; i < count && !this.nakadiEvents.isEmpty(); ++i) {
            Long offset = (Long)this.nakadiEvents.firstKey();
            result.put(offset, (String)this.nakadiEvents.remove(offset));
        }
        if (!result.isEmpty()) {
            this.sentOffset = (Long)result.lastKey();
            this.keepAliveInARow = 0;
        } else {
            ++this.keepAliveInARow;
        }
        return result;
    }

    int getKeepAliveInARow() {
        return this.keepAliveInARow;
    }

    void ensureDataAvailable(long position) {
        if (position > this.commitOffset + 1L) {
            this.log.warn("Oldest kafka position is {} and commit offset is {}, updating", (Object)position, (Object)this.commitOffset);
            this.commitOffset = position;
        }
        if (position > this.sentOffset + 1L) {
            this.log.warn("Oldest kafka position is {} and sent offset is {}, updating", (Object)position, (Object)this.commitOffset);
            this.sentOffset = position;
        }
    }

    CommitResult onCommitOffset(Long offset) {
        long committed;
        boolean seekKafka = false;
        if (offset > this.sentOffset) {
            this.log.error("Commit in future: current: {}, committed {} will skip sending obsolete data", (Object)this.sentOffset, (Object)this.commitOffset);
            seekKafka = true;
            this.sentOffset = offset;
        }
        if (offset >= this.commitOffset) {
            committed = offset - this.commitOffset;
            this.commitOffset = offset;
        } else {
            this.log.error("Commits in past are evil!: Committing in {} while current commit is {}", (Object)offset, (Object)this.commitOffset);
            seekKafka = true;
            this.sentOffset = this.commitOffset = offset.longValue();
            committed = 0L;
        }
        while (this.nakadiEvents.floorKey(this.commitOffset) != null) {
            this.nakadiEvents.pollFirstEntry();
        }
        return new CommitResult(seekKafka, committed);
    }

    void addEventFromKafka(long offset, String event) {
        if (offset > this.sentOffset + (long)this.nakadiEvents.size() + 1L) {
            this.log.warn("Adding event from kafka that is too far from last sent. Dunno how it happened, but it is. Sent offset: {}, Commit offset: {}, Adding offset: {}", new Object[]{this.sentOffset, this.commitOffset, offset});
        }
        this.nakadiEvents.put(offset, event);
    }

    void clearEvents() {
        this.nakadiEvents.clear();
    }

    boolean isCommitted() {
        return this.sentOffset <= this.commitOffset;
    }

    long getUnconfirmed() {
        return this.sentOffset - this.commitOffset;
    }

    public ZKSubscription getSubscription() {
        return this.subscription;
    }

    static class CommitResult {
        final boolean seekOnKafka;
        final long committedCount;

        private CommitResult(boolean seekOnKafka, long committedCount) {
            this.seekOnKafka = seekOnKafka;
            this.committedCount = committedCount;
        }
    }
}

