/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zalando.nakadi.util.FlowIdUtils;

public class FlowIdRequestFilter
implements Filter {
    public static final String X_FLOW_ID_HEADER = "X-Flow-Id";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FlowIdUtils.clear();
        String flowId = null;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            flowId = httpServletRequest.getHeader(X_FLOW_ID_HEADER);
        }
        if (flowId == null) {
            flowId = FlowIdUtils.generateFlowId();
        }
        FlowIdUtils.push(flowId);
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.setHeader(X_FLOW_ID_HEADER, flowId);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            FlowIdUtils.clear();
        }
    }

    public void destroy() {
    }
}

