/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.util;

import org.json.JSONException;
import org.json.JSONObject;
import org.zalando.nakadi.exceptions.InvalidPartitionKeyFieldsException;

public class JsonPathAccess {
    private final JSONObject jsonObject;

    public JsonPathAccess(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public Object get(String path) throws InvalidPartitionKeyFieldsException {
        String field;
        JsonPathTokenizer pathTokenizer = new JsonPathTokenizer(path);
        Object curr = this.jsonObject;
        while ((field = pathTokenizer.nextToken()) != null) {
            if (!(curr instanceof JSONObject)) {
                throw new InvalidPartitionKeyFieldsException("field " + field + " doesn't exist.");
            }
            try {
                curr = curr.get(field);
            }
            catch (JSONException e) {
                throw new InvalidPartitionKeyFieldsException("field " + field + " doesn't exist.");
            }
        }
        return curr;
    }

    private static class JsonPathTokenizer {
        private final char[] path;
        private int pos = 0;
        private final StringBuilder tokenBuilder;

        private JsonPathTokenizer(String path) {
            this.path = path.toCharArray();
            this.tokenBuilder = new StringBuilder(this.path.length);
        }

        public synchronized String nextToken() {
            if (this.pos >= this.path.length) {
                return null;
            }
            this.tokenBuilder.setLength(0);
            boolean inSingleQuote = false;
            boolean escaped = false;
            while (this.pos < this.path.length) {
                char c = this.path[this.pos];
                ++this.pos;
                if (escaped) {
                    this.tokenBuilder.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\'') {
                    inSingleQuote = !inSingleQuote;
                    continue;
                }
                if (c == '.' && !inSingleQuote) break;
                this.tokenBuilder.append(c);
            }
            if (this.tokenBuilder.length() > 0) {
                return this.tokenBuilder.toString();
            }
            return null;
        }
    }
}

