/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.ValidationStrategyConfiguration;
import org.zalando.nakadi.validation.EventValidation;
import org.zalando.nakadi.validation.EventValidator;
import org.zalando.nakadi.validation.JSONSchemaValidator;
import org.zalando.nakadi.validation.OverrideDefinition;
import org.zalando.nakadi.validation.QualifiedJSONSchemaValidationChain;
import org.zalando.nakadi.validation.QualifiedJSONSchemaValidator;
import org.zalando.nakadi.validation.SchemaValidationOverrides;
import org.zalando.nakadi.validation.ValidationStrategy;

public class EventBodyMustRespectSchema
extends ValidationStrategy {
    public static final String NAME = "schema-validation";
    private static final Function<OverrideDefinition, QualifiedJSONSchemaValidator> TO_QUALIFIED_JSON_SCHEMA_VALIDATOR = t -> {
        JSONSchemaValidator jsv = new JSONSchemaValidator(t.getEffectiveSchema());
        return new QualifiedJSONSchemaValidator(t.getQualifier(), jsv);
    };

    @Override
    public EventValidator materialize(EventType eventType, ValidationStrategyConfiguration vsc) {
        JSONObject effectiveSchema = EventValidation.effectiveSchema(eventType);
        JSONSchemaValidator defaultSchemaValidator = new JSONSchemaValidator(effectiveSchema);
        if (vsc.getAdditionalConfiguration() == null) {
            return defaultSchemaValidator;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        Function<OverrideDefinition, OverrideDefinition> enhanceWithQualifiedSchema = definition -> {
            JSONObject schema = new JSONObject(eventType.getSchema().getSchema());
            JSONObject copy = new JSONObject(schema, JSONObject.getNames((JSONObject)schema));
            definition.getIgnoredProperties().forEach(name -> {
                copy.getJSONObject("properties").remove(name);
                JSONArray array = copy.getJSONArray("required");
                int idx = EventBodyMustRespectSchema.findElement(array, name);
                if (idx > -1) {
                    array.remove(idx);
                }
            });
            definition.setEffectiveSchema(copy);
            return definition;
        };
        List<QualifiedJSONSchemaValidator> qualifiedValidators = ((SchemaValidationOverrides)mapper.convertValue((Object)vsc.getAdditionalConfiguration(), SchemaValidationOverrides.class)).getOverrides().stream().map(enhanceWithQualifiedSchema).map(TO_QUALIFIED_JSON_SCHEMA_VALIDATOR).collect(Collectors.toList());
        return new QualifiedJSONSchemaValidationChain(qualifiedValidators, defaultSchemaValidator);
    }

    private static int findElement(JSONArray array, String element) {
        for (int i = 0; i < array.length(); ++i) {
            if (!element.equals(array.getString(i))) continue;
            return i;
        }
        return -1;
    }
}

