/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.LinksEnhancer;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.DocsMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HalBrowserMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HalJsonMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ResourceLoader;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.DefaultCurieProvider;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.TypeUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ManagementContextConfiguration
@ConditionalOnClass(value={Link.class})
@ConditionalOnWebApplication
@ConditionalOnBean(value={HttpMessageConverters.class})
@ConditionalOnProperty(value={"endpoints.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ResourceProperties.class})
public class EndpointWebMvcHypermediaManagementContextConfiguration {
    @Bean
    public ManagementServletContext managementServletContext(final ManagementServerProperties properties) {
        return new ManagementServletContext(){

            @Override
            public String getContextPath() {
                return properties.getContextPath();
            }
        };
    }

    @ConditionalOnProperty(prefix="endpoints.actuator", name={"enabled"}, matchIfMissing=true)
    @Bean
    public HalJsonMvcEndpoint halJsonMvcEndpoint(ManagementServletContext managementServletContext, ResourceProperties resources, ResourceLoader resourceLoader) {
        if (HalBrowserMvcEndpoint.getHalBrowserLocation(resourceLoader) != null) {
            return new HalBrowserMvcEndpoint(managementServletContext);
        }
        return new HalJsonMvcEndpoint(managementServletContext);
    }

    @Bean
    @ConditionalOnProperty(prefix="endpoints.docs", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnResource(resources={"classpath:/META-INF/resources/spring-boot-actuator/docs/index.html"})
    public DocsMvcEndpoint docsMvcEndpoint(ManagementServletContext managementServletContext) {
        return new DocsMvcEndpoint(managementServletContext);
    }

    @Bean
    @ConditionalOnBean(value={DocsMvcEndpoint.class})
    @ConditionalOnMissingBean(value={CurieProvider.class})
    @ConditionalOnProperty(prefix="endpoints.docs.curies", name={"enabled"}, matchIfMissing=false)
    public DefaultCurieProvider curieProvider(ServerProperties server, ManagementServerProperties management, DocsMvcEndpoint endpoint) {
        String path = management.getContextPath() + endpoint.getPath() + "/#spring_boot_actuator__{rel}";
        if (server.getPort().equals(management.getPort()) && management.getPort() != 0) {
            path = server.getPath(path);
        }
        return new DefaultCurieProvider("boot", new UriTemplate(path));
    }

    @JsonInclude(content=JsonInclude.Include.NON_NULL)
    @JacksonXmlRootElement(localName="resource")
    private static class EndpointResource
    extends ResourceSupport {
        private Object content;
        private Map<String, Object> embedded;

        EndpointResource(Object content, String path) {
            this.content = content instanceof Map ? null : content;
            this.embedded = (Map)(this.content == null ? content : null);
            this.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(Object.class).slash((Object)path)).withSelfRel());
        }

        @JsonUnwrapped
        public Object getContent() {
            return this.content;
        }

        @JsonAnyGetter
        public Map<String, Object> getEmbedded() {
            return this.embedded;
        }
    }

    @ConditionalOnProperty(prefix="endpoints.hypermedia", name={"enabled"}, matchIfMissing=false)
    @ControllerAdvice(assignableTypes={MvcEndpoint.class})
    public static class MvcEndpointAdvice
    implements ResponseBodyAdvice<Object> {
        @Autowired
        private List<RequestMappingHandlerAdapter> handlerAdapters;
        private Map<MediaType, HttpMessageConverter<?>> converterCache = new ConcurrentHashMap();

        public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
            Class controllerType = returnType.getDeclaringClass();
            return !HalJsonMvcEndpoint.class.isAssignableFrom(controllerType);
        }

        public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
            if (request instanceof ServletServerHttpRequest) {
                return this.beforeBodyWrite(body, returnType, selectedContentType, selectedConverterType, (ServletServerHttpRequest)request, response);
            }
            return body;
        }

        private Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServletServerHttpRequest request, ServerHttpResponse response) {
            if (body == null || body instanceof Resource) {
                return body;
            }
            if (body instanceof Collection || body.getClass().isArray()) {
                return body;
            }
            HttpMessageConverter<Object> converter = this.findConverter(selectedConverterType, selectedContentType);
            if (converter == null || this.isHypermediaDisabled(returnType)) {
                return body;
            }
            String path = this.getPath(request);
            try {
                converter.write((Object)new EndpointResource(body, path), selectedContentType, (HttpOutputMessage)response);
            }
            catch (IOException ex) {
                throw new HttpMessageNotWritableException("Cannot write response", (Throwable)ex);
            }
            return null;
        }

        private HttpMessageConverter<Object> findConverter(Class<? extends HttpMessageConverter<?>> selectedConverterType, MediaType mediaType) {
            if (this.converterCache.containsKey(mediaType)) {
                return this.converterCache.get(mediaType);
            }
            for (RequestMappingHandlerAdapter handlerAdapter : this.handlerAdapters) {
                for (HttpMessageConverter converter : handlerAdapter.getMessageConverters()) {
                    if (!selectedConverterType.isAssignableFrom(converter.getClass()) || !converter.canWrite(EndpointResource.class, mediaType)) continue;
                    this.converterCache.put(mediaType, converter);
                    return converter;
                }
            }
            return null;
        }

        private boolean isHypermediaDisabled(MethodParameter returnType) {
            return AnnotationUtils.findAnnotation((Method)returnType.getMethod(), HypermediaDisabled.class) != null || AnnotationUtils.findAnnotation(returnType.getMethod().getDeclaringClass(), HypermediaDisabled.class) != null;
        }

        private String getPath(ServletServerHttpRequest request) {
            String path = (String)request.getServletRequest().getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
            return path == null ? "" : path;
        }
    }

    @ControllerAdvice
    public static class ActuatorEndpointLinksAdvice
    implements ResponseBodyAdvice<Object> {
        @Autowired
        private MvcEndpoints endpoints;
        @Autowired(required=false)
        private HalJsonMvcEndpoint halJsonMvcEndpoint;
        @Autowired
        private ManagementServerProperties management;
        private LinksEnhancer linksEnhancer;

        @PostConstruct
        public void init() {
            this.linksEnhancer = new LinksEnhancer(this.management.getContextPath(), this.endpoints);
        }

        public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
            returnType.increaseNestingLevel();
            Type nestedType = returnType.getNestedGenericParameterType();
            returnType.decreaseNestingLevel();
            return ResourceSupport.class.isAssignableFrom(returnType.getParameterType()) || TypeUtils.isAssignable(ResourceSupport.class, (Type)nestedType);
        }

        public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
            if (request instanceof ServletServerHttpRequest) {
                this.beforeBodyWrite(body, (ServletServerHttpRequest)request);
            }
            return body;
        }

        private void beforeBodyWrite(Object body, ServletServerHttpRequest request) {
            Object pattern = request.getServletRequest().getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
            if (pattern != null && body instanceof ResourceSupport) {
                this.beforeBodyWrite(pattern.toString(), (ResourceSupport)body);
            }
        }

        private void beforeBodyWrite(String path, ResourceSupport body) {
            if (this.isActuatorEndpointPath(path)) {
                this.linksEnhancer.addEndpointLinks(body, this.halJsonMvcEndpoint.getPath());
            }
        }

        private boolean isActuatorEndpointPath(String path) {
            return this.halJsonMvcEndpoint != null && (this.management.getContextPath() + this.halJsonMvcEndpoint.getPath()).equals(path);
        }
    }
}

