/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@ConfigurationProperties(value="endpoints.actuator")
public class HalJsonMvcEndpoint
extends WebMvcConfigurerAdapter
implements MvcEndpoint,
EnvironmentAware {
    private Environment environment;
    @NotNull
    @Pattern(regexp="^$|/[^/]*", message="Path must be empty or start with /")
    private String path;
    private boolean enabled = true;
    private Boolean sensitive;
    private final ManagementServletContext managementServletContext;

    public HalJsonMvcEndpoint(ManagementServletContext managementServletContext) {
        this.managementServletContext = managementServletContext;
        this.path = this.getDefaultPath(managementServletContext);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private String getDefaultPath(ManagementServletContext managementServletContext) {
        if (StringUtils.hasText((String)managementServletContext.getContextPath())) {
            return "";
        }
        return "/actuator";
    }

    @RequestMapping(produces={"application/json"})
    @ResponseBody
    public ResourceSupport links() {
        return new ResourceSupport();
    }

    @RequestMapping(path={"/"}, produces={"application/json"})
    public String forward() {
        return "redirect:" + this.managementServletContext.getContextPath() + this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, false);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public Class<? extends Endpoint<?>> getEndpointType() {
        return null;
    }

    protected final ManagementServletContext getManagementServletContext() {
        return this.managementServletContext;
    }
}

