/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.DiskSpaceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.Health;

public class DiskSpaceHealthIndicator
extends AbstractHealthIndicator {
    private static final Log logger = LogFactory.getLog(DiskSpaceHealthIndicator.class);
    private final DiskSpaceHealthIndicatorProperties properties;

    @Autowired
    public DiskSpaceHealthIndicator(DiskSpaceHealthIndicatorProperties properties) {
        this.properties = properties;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        File path = this.properties.getPath();
        long diskFreeInBytes = path.getFreeSpace();
        if (diskFreeInBytes >= this.properties.getThreshold()) {
            builder.up();
        } else {
            logger.warn((Object)String.format("Free disk space below threshold. Available: %d bytes (threshold: %d bytes)", diskFreeInBytes, this.properties.getThreshold()));
            builder.down();
        }
        builder.withDetail("total", path.getTotalSpace()).withDetail("free", diskFreeInBytes).withDetail("threshold", this.properties.getThreshold());
    }
}

