/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.spring.server;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.http.OAuth2ErrorHandler;
import org.springframework.security.oauth2.client.resource.BaseOAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.zalando.stups.oauth2.spring.server.AuthenticationExtractor;
import org.zalando.stups.oauth2.spring.server.DefaultAuthenticationExtractor;
import org.zalando.stups.spring.http.client.ClientHttpRequestFactorySelector;

public class TokenInfoResourceServerTokenServices
implements ResourceServerTokenServices {
    private static final String SPACE = " ";
    private static final String CLIENT_ID_NOT_NEEDED = "CLIENT_ID_NOT_NEEDED";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String clientId;
    private final RestTemplate restTemplate;
    private final AuthenticationExtractor authenticationExtractor;
    private final URI tokenInfoEndpointUri;

    public TokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl) {
        this(tokenInfoEndpointUrl, CLIENT_ID_NOT_NEEDED);
    }

    public TokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl, String clientId) {
        this(tokenInfoEndpointUrl, clientId, new DefaultAuthenticationExtractor(), TokenInfoResourceServerTokenServices.buildRestTemplate());
    }

    public TokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl, AuthenticationExtractor authenticationExtractor) {
        this(tokenInfoEndpointUrl, CLIENT_ID_NOT_NEEDED, authenticationExtractor, TokenInfoResourceServerTokenServices.buildRestTemplate());
    }

    public TokenInfoResourceServerTokenServices(String tokenInfoEndpointUrl, String clientId, AuthenticationExtractor authenticationExtractor, RestTemplate restTemplate) {
        Assert.hasText((String)tokenInfoEndpointUrl, (String)"TokenInfoEndpointUrl should never be null or empty");
        try {
            new URL(tokenInfoEndpointUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("TokenInfoEndpointUrl is not an URL", e);
        }
        Assert.hasText((String)clientId, (String)"ClientId should never be null or empty");
        Assert.notNull((Object)authenticationExtractor, (String)"AuthenticationExtractor should never be null");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate should not be null");
        this.tokenInfoEndpointUri = URI.create(tokenInfoEndpointUrl);
        this.authenticationExtractor = authenticationExtractor;
        this.restTemplate = restTemplate;
        this.clientId = clientId;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        if (!StringUtils.hasText((String)accessToken)) {
            throw new InvalidTokenException("'accessToken' should never be null or empty");
        }
        Map<String, Object> map = null;
        try {
            map = this.getMap(accessToken);
        }
        catch (OAuth2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new TokenInfoEndpointException("Retrieving information to 'accessToken' failed.", e);
        }
        if (map.containsKey("error")) {
            this.logger.debug("userinfo returned error: " + map.get("error"));
            String description = (String)map.get("error_description");
            if (!StringUtils.hasText((String)description)) {
                description = (String)map.get("error");
            }
            throw new InvalidTokenException(description);
        }
        return this.authenticationExtractor.extractAuthentication(map, this.clientId);
    }

    public static RequestEntity<Void> buildRequestEntity(URI tokenInfoEndpointUri, String accessToken) {
        return RequestEntity.get((URI)tokenInfoEndpointUri).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Authorization", new String[]{"Bearer " + accessToken}).build();
    }

    public AuthenticationExtractor getAuthenticationExtractor() {
        return this.authenticationExtractor;
    }

    public static RestTemplate buildRestTemplate() {
        RestTemplate restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        BaseOAuth2ProtectedResourceDetails resource = new BaseOAuth2ProtectedResourceDetails();
        resource.setClientId("unused");
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorHandler((OAuth2ProtectedResourceDetails)resource));
        return restTemplate;
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }

    protected Map<String, Object> getMap(String accessToken) {
        Map map;
        this.logger.debug("Getting token-info from: {}", (Object)this.tokenInfoEndpointUri.toString());
        RequestEntity<Void> entity = TokenInfoResourceServerTokenServices.buildRequestEntity(this.tokenInfoEndpointUri, accessToken);
        Map result = map = (Map)this.restTemplate.exchange(entity, Map.class).getBody();
        return result;
    }

    static class TokenInfoEndpointException
    extends OAuth2Exception {
        private static final long serialVersionUID = 1L;
        private static final String DEFAULT_MESSAGE = "Unknown Exception when calling TokenInfoEndpoint";

        public TokenInfoEndpointException(Throwable t) {
            this(DEFAULT_MESSAGE, t);
        }

        public TokenInfoEndpointException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

