/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.zmon.actuator;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.StopWatch;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@Order(value=-2147483648)
public class ZmonMetricsFilter
extends OncePerRequestFilter {
    private static final int UNDEFINED_HTTP_STATUS = 999;
    private static final String UNKNOWN_PATH_SUFFIX = "/unmapped";
    private static final Log logger = LogFactory.getLog(ZmonMetricsFilter.class);
    private MetricRegistry metricRegistry;

    public ZmonMetricsFilter(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String path = new UrlPathHelper().getPathWithinApplication(request);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            status = this.getStatus(response);
        }
        finally {
            stopWatch.stop();
            this.recordMetrics(request, path, status, stopWatch.getTotalTimeMillis());
        }
    }

    private int getStatus(HttpServletResponse response) {
        try {
            return response.getStatus();
        }
        catch (Exception ex) {
            return 999;
        }
    }

    private void recordMetrics(HttpServletRequest request, String path, int status, long time) {
        String suffix = this.getFinalStatus(request, path, status);
        this.submitToTimer(this.getKey("zmon.response." + status + "." + request.getMethod().toUpperCase() + suffix), time);
    }

    private String getFinalStatus(HttpServletRequest request, String path, int status) {
        Object bestMatchingPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (bestMatchingPattern != null) {
            return this.fixSpecialCharacters(bestMatchingPattern.toString());
        }
        return UNKNOWN_PATH_SUFFIX;
    }

    private String fixSpecialCharacters(String value) {
        String result = value.replaceAll("[{}]", "-");
        result = result.replace("**", "-star-star-");
        result = result.replace("*", "-star-");
        result = result.replace("/-", "/");
        if ((result = result.replace("-/", "/")).endsWith("-")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith("-")) {
            result = result.substring(1);
        }
        return result;
    }

    private String getKey(String string) {
        String value = string.replace("/", ".");
        if ((value = value.replace("..", ".")).endsWith(".")) {
            value = value + "root";
        }
        if (value.startsWith("_")) {
            value = value.substring(1);
        }
        return value;
    }

    private void submitToTimer(String metricName, long value) {
        try {
            Timer timer = this.metricRegistry.timer(metricName);
            timer.update(value, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to submit timer metric '" + metricName + "'"), (Throwable)e);
        }
    }
}

