/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import java.io.PrintStream;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ConsoleReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<ConsoleReporter> {
    public static final String PERIOD = "period";
    public static final String CLOCK_REF = "clock-ref";
    public static final String OUTPUT_REF = "output-ref";
    public static final String LOCALE = "locale";
    public static final String TIMEZONE = "timezone";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";

    @Override
    public Class<ConsoleReporter> getObjectType() {
        return ConsoleReporter.class;
    }

    @Override
    protected ConsoleReporter createInstance() {
        ConsoleReporter.Builder reporter = ConsoleReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        reporter.filter(this.getMetricFilter());
        if (this.hasProperty(CLOCK_REF)) {
            reporter.withClock(this.getPropertyRef(CLOCK_REF, Clock.class));
        }
        if (this.hasProperty(OUTPUT_REF)) {
            reporter.outputTo(this.getPropertyRef(OUTPUT_REF, PrintStream.class));
        }
        if (this.hasProperty(LOCALE)) {
            reporter.formattedFor(this.parseLocale(this.getProperty(LOCALE)));
        }
        if (this.hasProperty(TIMEZONE)) {
            reporter.formattedFor(TimeZone.getTimeZone(this.getProperty(TIMEZONE)));
        }
        return reporter.build();
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }

    protected Locale parseLocale(String localeString) {
        int underscore = localeString.indexOf(95);
        if (underscore == -1) {
            return new Locale(localeString);
        }
        return new Locale(localeString.substring(0, underscore), localeString.substring(underscore + 1));
    }
}

