/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.oauth2.spring.security.expression;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.provider.expression.OAuth2SecurityExpressionMethods;
import org.zalando.stups.oauth2.spring.security.expression.RealmOAuth2ExpressionUtils;

public class ExtendedOAuth2SecurityExpressionMethods
extends OAuth2SecurityExpressionMethods {
    private Set<String> missingRealms = new LinkedHashSet<String>();
    private final Authentication authentication;
    private final String[] uidScope = new String[]{"uid"};

    public boolean throwOnError(boolean decision) {
        if (!decision && !this.missingRealms.isEmpty()) {
            InsufficientScopeException failure = new InsufficientScopeException("Insufficient realms for this resource", this.missingRealms);
            throw new AccessDeniedException(failure.getMessage(), (Throwable)failure);
        }
        return super.throwOnError(decision);
    }

    public ExtendedOAuth2SecurityExpressionMethods(Authentication authentication) {
        super(authentication);
        this.authentication = authentication;
    }

    public boolean hasRealm(String realm) {
        return this.hasAnyRealm(realm);
    }

    public boolean hasAnyRealm(String ... realms) {
        boolean result = RealmOAuth2ExpressionUtils.hasAnyRealm(this.authentication, realms);
        if (!result) {
            this.missingRealms.addAll(Arrays.asList(realms));
        }
        return result;
    }

    public boolean hasUidScopeAndRealm(String realm) {
        return this.hasUidScopeAndAnyRealm(realm);
    }

    public boolean hasUidScopeAndAnyRealm(String ... realms) {
        boolean scopeResult = RealmOAuth2ExpressionUtils.hasAnyScope((Authentication)this.authentication, (String[])this.uidScope);
        boolean realmResult = RealmOAuth2ExpressionUtils.hasAnyRealm(this.authentication, realms);
        if (!realmResult) {
            this.missingRealms.addAll(Arrays.asList(realms));
        }
        return realmResult && scopeResult;
    }
}

