/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.zalando.problem.ProblemModule;

@Configuration
public class JsonConfig {
    @Bean
    @Primary
    public ObjectMapper jacksonObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        objectMapper.registerModule((Module)this.enumModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new ProblemModule());
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return objectMapper;
    }

    private SimpleModule enumModule() {
        SimpleModule enumModule = new SimpleModule();
        enumModule.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new LowerCaseEnumJsonDeserializer(type);
            }
        });
        enumModule.addSerializer(Enum.class, (JsonSerializer)new LowerCaseEnumJsonSerializer());
        return enumModule;
    }

    private static class LowerCaseEnumJsonSerializer
    extends StdSerializer<Enum> {
        public LowerCaseEnumJsonSerializer() {
            super(Enum.class);
        }

        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name().toLowerCase());
        }
    }

    private static class LowerCaseEnumJsonDeserializer
    extends JsonDeserializer<Enum> {
        private final JavaType type;

        public LowerCaseEnumJsonDeserializer(JavaType type) {
            this.type = type;
        }

        public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Class rawClass = this.type.getRawClass();
            String jpValueAsString = jp.getValueAsString();
            try {
                return Enum.valueOf(rawClass, jpValueAsString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                String possibleValues = Arrays.stream(rawClass.getEnumConstants()).map(enumValue -> enumValue.name().toLowerCase()).collect(Collectors.joining(", "));
                throw new JsonMappingException("Illegal enum value: '" + jpValueAsString + "'. Possible values: [" + possibleValues + "]");
            }
        }
    }
}

