/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.problem;

import com.google.common.base.CaseFormat;
import java.net.URI;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.zalando.problem.MoreStatus;
import org.zalando.problem.Problem;

public class ValidationProblem
implements Problem {
    private final Errors errors;
    private static final String TYPE_VALUE = "http://httpstatus.es/422";
    private static final URI TYPE = URI.create("http://httpstatus.es/422");
    private static final String TITLE = "Unprocessable Entity";

    public ValidationProblem(Errors errors) {
        this.errors = errors;
    }

    public URI getType() {
        return TYPE;
    }

    public String getTitle() {
        return TITLE;
    }

    public Response.StatusType getStatus() {
        return MoreStatus.UNPROCESSABLE_ENTITY;
    }

    public Optional<String> getDetail() {
        return Optional.of(this.buildErrorMessage());
    }

    private String buildErrorMessage() {
        StringBuilder detailBuilder = new StringBuilder();
        for (ObjectError error : this.errors.getAllErrors()) {
            if (error instanceof FieldError) {
                String fieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ((FieldError)error).getField());
                detailBuilder.append("Field \"").append(fieldName).append("\" ").append(error.getDefaultMessage()).append("\n");
                continue;
            }
            detailBuilder.append(error.toString());
        }
        return detailBuilder.toString();
    }
}

