/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.db;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.annotations.DB;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.exceptions.DuplicatedEventTypeNameException;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.db.AbstractDbRepository;

@DB
@Component
public class EventTypeDbRepository
extends AbstractDbRepository
implements EventTypeRepository {
    @Autowired
    public EventTypeDbRepository(JdbcTemplate jdbcTemplate, ObjectMapper objectMapper) {
        super(jdbcTemplate, objectMapper);
    }

    @Override
    public void saveEventType(EventType eventType) throws InternalNakadiException, DuplicatedEventTypeNameException {
        try {
            this.jdbcTemplate.update("INSERT INTO zn_data.event_type (et_name, et_topic, et_event_type_object) VALUES (?, ?, ?::jsonb)", new Object[]{eventType.getName(), eventType.getTopic(), this.jsonMapper.writer().writeValueAsString((Object)eventType)});
        }
        catch (JsonProcessingException e) {
            throw new InternalNakadiException("Serialization problem during persistence of event type", (Exception)((Object)e));
        }
        catch (DuplicateKeyException e) {
            throw new DuplicatedEventTypeNameException("EventType " + eventType.getName() + " already exists.", (Exception)((Object)e));
        }
    }

    @Override
    public EventType findByName(String name) throws NoSuchEventTypeException {
        String sql = "SELECT et_topic, et_event_type_object FROM zn_data.event_type WHERE et_name = ?";
        try {
            return (EventType)this.jdbcTemplate.queryForObject("SELECT et_topic, et_event_type_object FROM zn_data.event_type WHERE et_name = ?", new Object[]{name}, (RowMapper)new EventTypeMapper());
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchEventTypeException("EventType \"" + name + "\" does not exist.", (Exception)((Object)e));
        }
    }

    @Override
    public void update(EventType eventType) throws InternalNakadiException {
        try {
            this.jdbcTemplate.update("UPDATE zn_data.event_type SET et_event_type_object = ?::jsonb WHERE et_name = ?", new Object[]{this.jsonMapper.writer().writeValueAsString((Object)eventType), eventType.getName()});
        }
        catch (JsonProcessingException e) {
            throw new InternalNakadiException("Serialization problem during persistence of event type \"" + eventType.getName() + "\"", (Exception)((Object)e));
        }
    }

    @Override
    public List<EventType> list() {
        return this.jdbcTemplate.query("SELECT et_topic, et_event_type_object FROM zn_data.event_type", (RowMapper)new EventTypeMapper());
    }

    @Override
    public void removeEventType(String name) throws NoSuchEventTypeException, InternalNakadiException {
        try {
            int deletedRows = this.jdbcTemplate.update("DELETE FROM zn_data.event_type WHERE et_name = ?", new Object[]{name});
            if (deletedRows == 0) {
                throw new NoSuchEventTypeException("EventType " + name + " doesn't exist");
            }
        }
        catch (DataAccessException e) {
            throw new InternalNakadiException("Error occurred when deleting EventType " + name, (Exception)((Object)e));
        }
    }

    private class EventTypeMapper
    implements RowMapper<EventType> {
        private EventTypeMapper() {
        }

        public EventType mapRow(ResultSet rs, int rowNum) throws SQLException {
            try {
                EventType eventType = (EventType)EventTypeDbRepository.this.jsonMapper.readValue(rs.getString("et_event_type_object"), EventType.class);
                eventType.setTopic(rs.getString("et_topic"));
                return eventType;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }
}

