/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.kafka;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.curator.framework.CuratorFramework;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.repository.zookeeper.ZooKeeperHolder;

@Component
@Profile(value={"!test"})
public class KafkaLocationManager {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaLocationManager.class);
    private static final String BROKERS_IDS_PATH = "/brokers/ids";
    private final ZooKeeperHolder zkFactory;
    private Properties kafkaProperties;

    @Autowired
    public KafkaLocationManager(ZooKeeperHolder zkFactory) {
        this.zkFactory = zkFactory;
        this.kafkaProperties = this.buildKafkaProperties(this.fetchBrokers());
    }

    private List<Broker> fetchBrokers() {
        ArrayList<Broker> brokers = new ArrayList<Broker>();
        try {
            CuratorFramework curator = this.zkFactory.get();
            for (String brokerId : (List)curator.getChildren().forPath(BROKERS_IDS_PATH)) {
                try {
                    byte[] brokerData = (byte[])curator.getData().forPath("/brokers/ids/" + brokerId);
                    brokers.add(Broker.fromByteJson(brokerData));
                }
                catch (Exception e) {
                    LOG.info(String.format("Failed to fetch connection string for broker %s", brokerId), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to fetch list of brokers from ZooKeeper", (Throwable)e);
        }
        return brokers;
    }

    private static String buildBootstrapServers(List<Broker> brokers) {
        StringBuilder builder = new StringBuilder();
        brokers.stream().forEach(broker -> builder.append(broker).append(","));
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    private Properties buildKafkaProperties(List<Broker> brokers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", KafkaLocationManager.buildBootstrapServers(brokers));
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        return props;
    }

    @Scheduled(fixedDelay=30000L)
    private void updateBrokers() {
        List<Broker> brokers;
        if (this.kafkaProperties != null && !(brokers = this.fetchBrokers()).isEmpty()) {
            this.kafkaProperties.setProperty("bootstrap.servers", KafkaLocationManager.buildBootstrapServers(brokers));
        }
    }

    public Properties getKafkaProperties() {
        return (Properties)this.kafkaProperties.clone();
    }

    public Properties getKafkaProducerProperties() {
        Properties producerProps = this.getKafkaProperties();
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("acks", "all");
        return producerProps;
    }

    static class Broker {
        final String host;
        final Integer port;

        private Broker(String host, Integer port) {
            this.host = host;
            this.port = port;
        }

        static Broker fromByteJson(byte[] data) throws JSONException, UnsupportedEncodingException {
            JSONObject json = new JSONObject(new String(data, "UTF-8"));
            String host = json.getString("host");
            Integer port = json.getInt("port");
            return new Broker(host, port);
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

