/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.repository.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;

public class KafkaPartitionsCalculator {
    private final NavigableMap<Integer, float[]> stats = new TreeMap<Integer, float[]>();
    private static final String PARTITION_STATISTICS = "/partitions_statistics.json";

    private KafkaPartitionsCalculator(InstanceInfo instanceInfo) {
        for (SpeedStatistics ss : instanceInfo.getStats()) {
            this.stats.put(ss.getMessageSize(), ss.getSpeed());
        }
    }

    public int getBestPartitionsCount(int messageSize, float mbsPerSecond) {
        Map.Entry<Integer, float[]> floor = this.stats.floorEntry(messageSize);
        Map.Entry<Integer, float[]> ceil = this.stats.ceilingEntry(messageSize);
        if (floor == null) {
            return KafkaPartitionsCalculator.getBestPartitionsCount(ceil.getValue(), mbsPerSecond);
        }
        if (ceil == null) {
            return KafkaPartitionsCalculator.getBestPartitionsCount(floor.getValue(), mbsPerSecond);
        }
        int floorResult = KafkaPartitionsCalculator.getBestPartitionsCount(floor.getValue(), mbsPerSecond);
        if (Objects.equals(floor.getKey(), ceil.getKey())) {
            return floorResult;
        }
        int ceilResult = KafkaPartitionsCalculator.getBestPartitionsCount(ceil.getValue(), mbsPerSecond);
        return floorResult + (ceilResult - floorResult) * (messageSize - floor.getKey()) / (ceil.getKey() - floor.getKey());
    }

    private static int getBestPartitionsCount(float[] perPartitionThroughput, float mbsPerSecond) {
        int nearestIndex = -1;
        for (int i = 0; i < perPartitionThroughput.length; ++i) {
            if (mbsPerSecond <= perPartitionThroughput[i]) {
                return i + 1;
            }
            if (nearestIndex != -1 && !(perPartitionThroughput[nearestIndex] < perPartitionThroughput[i])) continue;
            nearestIndex = i;
        }
        return nearestIndex + 1;
    }

    static KafkaPartitionsCalculator load(ObjectMapper objectMapper, String instanceType) throws IOException {
        try (InputStream in = KafkaPartitionsCalculator.class.getResourceAsStream(PARTITION_STATISTICS);){
            if (null == in) {
                throw new IOException("Resource with name /partitions_statistics.json is not found");
            }
            KafkaPartitionsCalculator kafkaPartitionsCalculator = KafkaPartitionsCalculator.load(objectMapper, instanceType, in);
            return kafkaPartitionsCalculator;
        }
    }

    @VisibleForTesting
    static KafkaPartitionsCalculator load(ObjectMapper objectMapper, String instanceType, InputStream in) throws IOException {
        InstanceInfo[] instanceInfos = (InstanceInfo[])objectMapper.readValue(in, InstanceInfo[].class);
        InstanceInfo instanceInfo = Stream.of(instanceInfos).filter(ii -> instanceType.equals(ii.getName())).findAny().orElseThrow(() -> new IllegalArgumentException("Failed to find instance " + instanceType + " configuration"));
        return new KafkaPartitionsCalculator(instanceInfo);
    }

    private static class InstanceInfo {
        private String name;
        private SpeedStatistics[] stats;

        private InstanceInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SpeedStatistics[] getStats() {
            return this.stats;
        }

        public void setStats(SpeedStatistics[] stats) {
            this.stats = stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstanceInfo that = (InstanceInfo)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return Arrays.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class SpeedStatistics {
        private int messageSize;
        private float[] speed;

        private SpeedStatistics() {
        }

        public int getMessageSize() {
            return this.messageSize;
        }

        public void setMessageSize(int messageSize) {
            this.messageSize = messageSize;
        }

        public float[] getSpeed() {
            return this.speed;
        }

        public void setSpeed(float[] speed) {
            this.speed = speed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpeedStatistics that = (SpeedStatistics)o;
            if (this.messageSize != that.messageSize) {
                return false;
            }
            return Arrays.equals(this.speed, that.speed);
        }

        public int hashCode() {
            return this.messageSize;
        }
    }
}

