/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.nakadi.exceptions.UnprocessableEntityException;

@Immutable
public class EventStreamConfig {
    private static final int BATCH_LIMIT_DEFAULT = 1;
    private static final int STREAM_LIMIT_DEFAULT = 0;
    private static final int BATCH_FLUSH_TIMEOUT_DEFAULT = 30;
    private static final int STREAM_TIMEOUT_DEFAULT = 0;
    private static final int STREAM_KEEP_ALIVE_LIMIT_DEFAULT = 0;
    private final String topic;
    private final Map<String, String> cursors;
    private final int batchLimit;
    private final int streamLimit;
    private final int batchTimeout;
    private final int streamTimeout;
    private final int streamKeepAliveLimit;

    private EventStreamConfig(String topic, Map<String, String> cursors, int batchLimit, int streamLimit, int batchTimeout, int streamTimeout, int streamKeepAliveLimit) {
        this.topic = topic;
        this.cursors = cursors;
        this.batchLimit = batchLimit;
        this.streamLimit = streamLimit;
        this.batchTimeout = batchTimeout;
        this.streamTimeout = streamTimeout;
        this.streamKeepAliveLimit = streamKeepAliveLimit;
    }

    public String getTopic() {
        return this.topic;
    }

    public Map<String, String> getCursors() {
        return this.cursors;
    }

    public int getBatchLimit() {
        return this.batchLimit;
    }

    public int getStreamLimit() {
        return this.streamLimit;
    }

    public int getBatchTimeout() {
        return this.batchTimeout;
    }

    public int getStreamTimeout() {
        return this.streamTimeout;
    }

    public int getStreamKeepAliveLimit() {
        return this.streamKeepAliveLimit;
    }

    public String toString() {
        return "EventStreamConfig{topic='" + this.topic + '\'' + ", cursors=" + this.cursors + ", batchLimit=" + this.batchLimit + ", streamLimit=" + this.streamLimit + ", batchTimeout=" + this.batchTimeout + ", streamTimeout=" + this.streamTimeout + ", streamKeepAliveLimit=" + this.streamKeepAliveLimit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventStreamConfig that = (EventStreamConfig)o;
        if (this.batchLimit != that.batchLimit) {
            return false;
        }
        if (this.streamLimit != that.streamLimit) {
            return false;
        }
        if (this.batchTimeout != that.batchTimeout) {
            return false;
        }
        if (this.streamTimeout != that.streamTimeout) {
            return false;
        }
        if (this.streamKeepAliveLimit != that.streamKeepAliveLimit) {
            return false;
        }
        if (!this.topic.equals(that.topic)) {
            return false;
        }
        return this.cursors.equals(that.cursors);
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.cursors.hashCode();
        result = 31 * result + this.batchLimit;
        result = 31 * result + this.streamLimit;
        result = 31 * result + this.batchTimeout;
        result = 31 * result + this.streamTimeout;
        result = 31 * result + this.streamKeepAliveLimit;
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String topic = null;
        private Map<String, String> cursors = ImmutableMap.of();
        private int batchLimit = 1;
        private int streamLimit = 0;
        private int batchTimeout = 30;
        private int streamTimeout = 0;
        private int streamKeepAliveLimit = 0;

        public Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder withCursors(Map<String, String> cursors) {
            this.cursors = cursors;
            return this;
        }

        public Builder withBatchLimit(@Nullable Integer batchLimit) {
            if (batchLimit != null) {
                this.batchLimit = batchLimit;
            }
            return this;
        }

        public Builder withStreamLimit(@Nullable Integer streamLimit) {
            if (streamLimit != null) {
                this.streamLimit = streamLimit;
            }
            return this;
        }

        public Builder withBatchTimeout(@Nullable Integer batchTimeout) {
            if (batchTimeout != null) {
                this.batchTimeout = batchTimeout == 0 ? 30 : batchTimeout;
            }
            return this;
        }

        public Builder withStreamTimeout(@Nullable Integer streamTimeout) {
            if (streamTimeout != null) {
                this.streamTimeout = streamTimeout;
            }
            return this;
        }

        public Builder withStreamKeepAliveLimit(@Nullable Integer streamKeepAliveLimit) {
            if (streamKeepAliveLimit != null) {
                this.streamKeepAliveLimit = streamKeepAliveLimit;
            }
            return this;
        }

        public EventStreamConfig build() throws UnprocessableEntityException {
            if (this.topic == null) {
                throw new IllegalStateException("Topic should be specified");
            }
            if (this.streamLimit != 0 && this.streamLimit < this.batchLimit) {
                throw new UnprocessableEntityException("stream_limit can't be lower than batch_limit");
            }
            if (this.streamTimeout != 0 && this.streamTimeout < this.batchTimeout) {
                throw new UnprocessableEntityException("stream_timeout can't be lower than batch_flush_timeout");
            }
            return new EventStreamConfig(this.topic, this.cursors, this.batchLimit, this.streamLimit, this.batchTimeout, this.streamTimeout, this.streamKeepAliveLimit);
        }
    }
}

