/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.zk;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadi.exceptions.ExceptionWrapper;
import org.zalando.nakadi.service.subscription.model.Partition;
import org.zalando.nakadi.service.subscription.model.Session;
import org.zalando.nakadi.service.subscription.zk.ChangeListener;
import org.zalando.nakadi.service.subscription.zk.ZKSubscription;
import org.zalando.nakadi.service.subscription.zk.ZkSubscriptionClient;

public class CuratorZkSubscriptionClient
implements ZkSubscriptionClient {
    private static final String STATE_INITIALIZED = "INITIALIZED";
    private static final String NO_SESSION = "";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final CuratorFramework curatorFramework;
    private final InterProcessSemaphoreMutex lock;
    private final String subscriptionId;
    private final Logger log;

    public CuratorZkSubscriptionClient(String subscriptionId, CuratorFramework curatorFramework) {
        this(subscriptionId, curatorFramework, CuratorZkSubscriptionClient.class.getName());
    }

    public CuratorZkSubscriptionClient(String subscriptionId, CuratorFramework curatorFramework, String loggingPath) {
        this.subscriptionId = subscriptionId;
        this.curatorFramework = curatorFramework;
        this.lock = new InterProcessSemaphoreMutex(curatorFramework, "/nakadi/locks/subscription_" + subscriptionId);
        this.log = LoggerFactory.getLogger((String)(loggingPath + ".zk"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runLocked(Runnable function) {
        this.log.info("Taking lock for " + function.hashCode());
        try {
            Exception releaseException = null;
            this.lock.acquire();
            this.log.debug("Lock taken " + function.hashCode());
            try {
                function.run();
            }
            finally {
                this.log.info("Releasing lock for " + function.hashCode());
                try {
                    this.lock.release();
                }
                catch (Exception e) {
                    this.log.error("Failed to release lock", (Throwable)e);
                    releaseException = e;
                }
                this.log.debug("Lock released " + function.hashCode());
            }
            if (releaseException != null) {
                throw releaseException;
            }
        }
        catch (ExceptionWrapper e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    private String getSubscriptionPath(String value) {
        return "/nakadi/subscriptions/" + this.subscriptionId + value;
    }

    private String getPartitionPath(Partition.PartitionKey key) {
        return this.getSubscriptionPath("/topics/" + key.topic + "/" + key.partition);
    }

    @Override
    public boolean isSubscriptionCreated() throws Exception {
        Stat stat = (Stat)this.curatorFramework.checkExists().forPath(this.getSubscriptionPath(NO_SESSION));
        return stat != null;
    }

    @Override
    public boolean createSubscription() {
        try {
            String statePath = this.getSubscriptionPath("/state");
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(statePath);
            if (null == stat) {
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(statePath);
                return true;
            }
            String state = new String((byte[])this.curatorFramework.getData().forPath(statePath), CHARSET);
            return !state.equals(STATE_INITIALIZED);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public void fillEmptySubscription(Map<Partition.PartitionKey, Long> partitionToOffset) {
        try {
            this.log.info("Creating sessions root");
            if (null != this.curatorFramework.checkExists().forPath(this.getSubscriptionPath("/sessions"))) {
                this.curatorFramework.delete().guaranteed().deletingChildrenIfNeeded().forPath(this.getSubscriptionPath("/sessions"));
            }
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.PERSISTENT)).forPath(this.getSubscriptionPath("/sessions"));
            this.log.info("Creating topics");
            if (null != this.curatorFramework.checkExists().forPath(this.getSubscriptionPath("/topics"))) {
                this.log.info("deleting topics recursively");
                this.curatorFramework.delete().guaranteed().deletingChildrenIfNeeded().forPath(this.getSubscriptionPath("/topics"));
            }
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.PERSISTENT)).forPath(this.getSubscriptionPath("/topics"));
            this.log.info("Creating partitions");
            for (Map.Entry<Partition.PartitionKey, Long> p : partitionToOffset.entrySet()) {
                String partitionPath = this.getPartitionPath(p.getKey());
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(partitionPath, CuratorZkSubscriptionClient.serializeNode(null, null, Partition.State.UNASSIGNED));
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.PERSISTENT)).forPath(partitionPath + "/offset", String.valueOf(p.getValue()).getBytes(CHARSET));
            }
            this.log.info("creating topology node");
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.PERSISTENT)).forPath(this.getSubscriptionPath("/topology"), "0".getBytes(CHARSET));
            this.log.info("updating state");
            this.curatorFramework.setData().forPath(this.getSubscriptionPath("/state"), STATE_INITIALIZED.getBytes(CHARSET));
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    private static byte[] serializeNode(@Nullable String session, @Nullable String nextSession, Partition.State state) {
        return Stream.of(session == null ? NO_SESSION : session, nextSession == null ? NO_SESSION : nextSession, state.name()).collect(Collectors.joining(":")).getBytes(CHARSET);
    }

    private static Partition deserializeNode(Partition.PartitionKey key, byte[] data) {
        String[] parts = new String(data, CHARSET).split(":");
        return new Partition(key, NO_SESSION.equals(parts[0]) ? null : parts[0], NO_SESSION.equals(parts[1]) ? null : parts[1], Partition.State.valueOf(parts[2]));
    }

    @Override
    public void updatePartitionConfiguration(Partition partition) {
        try {
            this.log.info("updating partition state: " + partition.getKey() + ":" + (Object)((Object)partition.getState()) + ":" + partition.getSession() + ":" + partition.getNextSession());
            this.curatorFramework.setData().forPath(this.getPartitionPath(partition.getKey()), CuratorZkSubscriptionClient.serializeNode(partition.getSession(), partition.getNextSession(), partition.getState()));
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public void incrementTopology() {
        try {
            this.log.info("Incrementing topology version");
            Integer curVersion = Integer.parseInt(new String((byte[])this.curatorFramework.getData().forPath(this.getSubscriptionPath("/topology")), CHARSET));
            this.curatorFramework.setData().forPath(this.getSubscriptionPath("/topology"), String.valueOf(curVersion + 1).getBytes(CHARSET));
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public Partition[] listPartitions() {
        this.log.info("fetching partitions information");
        try {
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            for (String topic : (List)this.curatorFramework.getChildren().forPath(this.getSubscriptionPath("/topics"))) {
                for (String partition : (List)this.curatorFramework.getChildren().forPath(this.getSubscriptionPath("/topics/" + topic))) {
                    Partition.PartitionKey key = new Partition.PartitionKey(topic, partition);
                    partitions.add(CuratorZkSubscriptionClient.deserializeNode(key, (byte[])this.curatorFramework.getData().forPath(this.getPartitionPath(key))));
                }
            }
            return partitions.toArray(new Partition[partitions.size()]);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public Session[] listSessions() {
        this.log.info("fetching sessions information");
        ArrayList<Session> sessions = new ArrayList<Session>();
        try {
            for (String sessionId : (List)this.curatorFramework.getChildren().forPath(this.getSubscriptionPath("/sessions"))) {
                int weight = Integer.parseInt(new String((byte[])this.curatorFramework.getData().forPath(this.getSubscriptionPath("/sessions/" + sessionId)), CHARSET));
                sessions.add(new Session(sessionId, weight));
            }
            return sessions.toArray(new Session[sessions.size()]);
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public ZKSubscription subscribeForSessionListChanges(Runnable listener) {
        this.log.info("subscribeForSessionListChanges: " + listener.hashCode());
        return ChangeListener.forChildren(this.curatorFramework, this.getSubscriptionPath("/sessions"), listener);
    }

    @Override
    public ZKSubscription subscribeForTopologyChanges(Runnable onTopologyChanged) {
        this.log.info("subscribeForTopologyChanges");
        return ChangeListener.forData(this.curatorFramework, this.getSubscriptionPath("/topology"), onTopologyChanged);
    }

    @Override
    public ZKSubscription subscribeForOffsetChanges(Partition.PartitionKey key, Runnable commitListener) {
        this.log.info("subscribeForOffsetChanges");
        return ChangeListener.forData(this.curatorFramework, this.getPartitionPath(key) + "/offset", commitListener);
    }

    @Override
    public long getOffset(Partition.PartitionKey key) {
        try {
            return Long.parseLong(new String((byte[])this.curatorFramework.getData().forPath(this.getPartitionPath(key) + "/offset"), CHARSET));
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public void registerSession(Session session) {
        this.log.info("Registering session " + session);
        try {
            String clientPath = this.getSubscriptionPath("/sessions/" + session.getId());
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL)).forPath(clientPath, String.valueOf(session.getWeight()).getBytes(CHARSET));
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public void unregisterSession(Session session) {
        try {
            this.curatorFramework.delete().guaranteed().forPath(this.getSubscriptionPath("/sessions/" + session.getId()));
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }

    @Override
    public void transfer(String sessionId, Collection<Partition.PartitionKey> partitions) {
        this.log.info("session " + sessionId + " releases partitions " + partitions);
        boolean changed = false;
        try {
            for (Partition.PartitionKey pk : partitions) {
                Partition realPartition = CuratorZkSubscriptionClient.deserializeNode(pk, (byte[])this.curatorFramework.getData().forPath(this.getPartitionPath(pk)));
                if (!sessionId.equals(realPartition.getSession()) || realPartition.getState() != Partition.State.REASSIGNING) continue;
                this.updatePartitionConfiguration(realPartition.toState(Partition.State.ASSIGNED, realPartition.getNextSession(), null));
                changed = true;
            }
            if (changed) {
                this.incrementTopology();
            }
        }
        catch (Exception e) {
            throw new ExceptionWrapper(e);
        }
    }
}

