/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import java.util.Optional;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadi.validation.EventValidator;
import org.zalando.nakadi.validation.RFC3339DateTimeValidator;
import org.zalando.nakadi.validation.ValidationError;

class JSONSchemaValidator
implements EventValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JSONSchemaValidator.class);
    private final Schema schema;
    private static final FormatValidator DATE_TIME_VALIDATOR = new RFC3339DateTimeValidator();

    public JSONSchemaValidator(JSONObject effectiveSchema) {
        this.schema = SchemaLoader.builder().schemaJson(effectiveSchema).addFormatValidator("date-time", DATE_TIME_VALIDATOR).build().load().build();
    }

    @Override
    public Optional<ValidationError> accepts(JSONObject event) {
        try {
            this.schema.validate((Object)event);
            return Optional.empty();
        }
        catch (ValidationException e) {
            StringBuilder builder = new StringBuilder();
            this.collectErrorMessages(e, builder);
            return Optional.of(new ValidationError(builder.toString()));
        }
    }

    private void collectErrorMessages(ValidationException e, StringBuilder builder) {
        builder.append(e.getMessage());
        e.getCausingExceptions().stream().forEach(causingException -> {
            builder.append("\n");
            this.collectErrorMessages((ValidationException)((Object)causingException), builder);
        });
    }
}

