/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.ValidationStrategyConfiguration;
import org.zalando.nakadi.validation.EventValidator;

public abstract class ValidationStrategy {
    private static final Map<String, ValidationStrategy> STRATEGIES = Maps.newHashMap();

    public abstract EventValidator materialize(EventType var1, ValidationStrategyConfiguration var2);

    public static final void register(String name, ValidationStrategy strategy) {
        STRATEGIES.put(name, strategy);
    }

    public static final ValidationStrategy lookup(String strategyName) {
        Preconditions.checkArgument((boolean)STRATEGIES.containsKey(strategyName), (String)"No such strategy {}", (Object[])new Object[]{strategyName});
        return STRATEGIES.get(strategyName);
    }
}

