/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.datatype.jdk8.OptionalDoubleSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalIntSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalLongSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalSerializer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class Jdk8Serializers
extends Serializers.Base {
    Jdk8Serializers() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class raw = type.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            return new OptionalSerializer(type);
        }
        if (OptionalInt.class.isAssignableFrom(raw)) {
            return OptionalIntSerializer.INSTANCE;
        }
        if (OptionalLong.class.isAssignableFrom(raw)) {
            return OptionalLongSerializer.INSTANCE;
        }
        if (OptionalDouble.class.isAssignableFrom(raw)) {
            return OptionalDoubleSerializer.INSTANCE;
        }
        return super.findSerializer(config, type, beanDesc);
    }
}

