/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Optional;

final class OptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final JavaType _referenceType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public OptionalDeserializer(JavaType fullType, JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._referenceType = refType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    @Deprecated
    public JavaType getValueType() {
        return this._fullType;
    }

    @Deprecated
    public Optional<?> getNullValue() {
        return Optional.empty();
    }

    public Optional<?> getNullValue(DeserializationContext ctxt) {
        return Optional.empty();
    }

    protected OptionalDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        return new OptionalDeserializer(this._fullType, this._referenceType, typeDeser, valueDeser);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        deser = deser == null ? ctxt.findContextualValueDeserializer(this._referenceType, property) : ctxt.handleSecondaryContextualization(deser, property, this._referenceType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(jp, ctxt) : this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        return Optional.of(refd);
    }

    public Optional<?> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue();
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(jp, ctxt);
        }
        return Optional.of(typeDeserializer.deserializeTypedFromAny(jp, ctxt));
    }
}

