/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONArraySerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONObjectSerializer
extends JSONBaseSerializer<JSONObject> {
    public static final JSONObjectSerializer instance = new JSONObjectSerializer();

    public JSONObjectSerializer() {
        super(JSONObject.class);
    }

    public void serialize(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(JSONObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject((Object)value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForObject((Object)value, jgen);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Iterator it = value.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object ob = value.opt(key);
            if (ob == null || ob == JSONObject.NULL) {
                if (!provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                jgen.writeNullField(key);
                continue;
            }
            jgen.writeFieldName(key);
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                this.serialize((JSONObject)ob, jgen, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber(((Integer)ob).intValue());
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber(((Long)ob).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber(((Double)ob).doubleValue());
                continue;
            }
            if (cls == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                this.serialize((JSONObject)ob, jgen, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, jgen);
        }
    }
}

