/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.common.collect.ImmutableMap;
import com.google.gag.annotation.remark.Hack;
import com.google.gag.annotation.remark.OhNoYouDidnt;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.core.Response;
import org.zalando.problem.ThrowableProblem;

@Immutable
public final class DefaultProblem
extends ThrowableProblem {
    private final URI type;
    private final String title;
    private final Response.StatusType status;
    private final Optional<String> detail;
    private final Optional<URI> instance;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    DefaultProblem(URI type, String title, Response.StatusType status, Optional<String> detail, Optional<URI> instance) {
        this(type, title, status, detail, instance, null);
    }

    DefaultProblem(URI type, String title, Response.StatusType status, Optional<String> detail, Optional<URI> instance, @Nullable ThrowableProblem cause) {
        super(cause);
        this.type = Objects.requireNonNull(type, "type must not be null");
        this.title = Objects.requireNonNull(title, "title must not be null");
        this.status = Objects.requireNonNull(status, "status must not be null");
        this.detail = Objects.requireNonNull(detail, "detail must not be null");
        this.instance = Objects.requireNonNull(instance, "instance must not be null");
    }

    @Override
    public URI getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Response.StatusType getStatus() {
        return this.status;
    }

    @Override
    public Optional<String> getDetail() {
        return this.detail;
    }

    @Override
    public Optional<URI> getInstance() {
        return this.instance;
    }

    @Override
    public ImmutableMap<String, Object> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    @Hack
    @OhNoYouDidnt
    void set(String key, Object value) {
        this.parameters.put(key, value);
    }
}

