/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.core.Response;
import org.zalando.problem.GenericProblems;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.ThrowableProblem;

@Immutable
public interface Problem {
    public URI getType();

    public String getTitle();

    public Response.StatusType getStatus();

    default public Optional<String> getDetail() {
        return Optional.empty();
    }

    default public Optional<URI> getInstance() {
        return Optional.empty();
    }

    default public ImmutableMap<String, Object> getParameters() {
        return ImmutableMap.of();
    }

    public static ProblemBuilder builder() {
        return new ProblemBuilder();
    }

    public static ThrowableProblem valueOf(Response.StatusType status) {
        return GenericProblems.create(status).build();
    }

    public static ThrowableProblem valueOf(Response.StatusType status, String detail) {
        return GenericProblems.create(status).withDetail(detail).build();
    }

    public static String toString(Problem problem) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)problem.getType().toString()).omitNullValues().addValue(problem.getStatus().getStatusCode()).addValue((Object)problem.getTitle()).addValue(problem.getDetail().orElse(null)).add("instance", problem.getInstance().orElse(null));
        problem.getParameters().forEach((arg_0, arg_1) -> ((MoreObjects.ToStringHelper)helper).add(arg_0, arg_1));
        return helper.toString();
    }
}

