/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.zalando.problem.UnknownStatus;

final class StatusTypeDeserializer
extends JsonDeserializer<Response.StatusType> {
    private final ImmutableMap<Integer, Response.StatusType> index;

    StatusTypeDeserializer(ImmutableMap<Integer, Response.StatusType> index) {
        this.index = index;
    }

    public Response.StatusType deserialize(JsonParser json, DeserializationContext context) throws IOException {
        int statusCode = json.getIntValue();
        Response.StatusType status = (Response.StatusType)this.index.get((Object)statusCode);
        return status == null ? new UnknownStatus(statusCode) : status;
    }
}

