/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class KafkaConsumer<K, V>
implements Consumer<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    private static final long NO_CURRENT_THREAD = -1L;
    private static final AtomicInteger CONSUMER_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.consumer";
    private String clientId;
    private final ConsumerCoordinator coordinator;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final Fetcher<K, V> fetcher;
    private final Time time;
    private final ConsumerNetworkClient client;
    private final Metrics metrics;
    private final SubscriptionState subscriptions;
    private final Metadata metadata;
    private final long retryBackoffMs;
    private long requestTimeoutMs;
    private boolean closed = false;
    private final AtomicLong currentThread = new AtomicLong(-1L);
    private final AtomicInteger refcount = new AtomicInteger(0);

    public KafkaConsumer(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public KafkaConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.addDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    public KafkaConsumer(Properties properties) {
        this(properties, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    public KafkaConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.addDeserializerToConfig(properties, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    private KafkaConsumer(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        try {
            log.debug("Starting the Kafka consumer");
            this.requestTimeoutMs = config.getInt("request.timeout.ms").intValue();
            int sessionTimeOutMs = config.getInt("session.timeout.ms");
            int fetchMaxWaitMs = config.getInt("fetch.max.wait.ms");
            if (this.requestTimeoutMs <= (long)sessionTimeOutMs || this.requestTimeoutMs <= (long)fetchMaxWaitMs) {
                throw new ConfigException("request.timeout.ms should be greater than session.timeout.ms and fetch.max.wait.ms");
            }
            this.time = new SystemTime();
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS);
            this.clientId = config.getString("client.id");
            if (this.clientId.length() <= 0) {
                this.clientId = "consumer-" + CONSUMER_CLIENT_ID_SEQUENCE.getAndIncrement();
            }
            List<MetricsReporter> reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            reporters.add(new JmxReporter(JMX_PREFIX));
            this.metrics = new Metrics(metricConfig, reporters, this.time);
            this.retryBackoffMs = config.getLong("retry.backoff.ms");
            this.metadata = new Metadata(this.retryBackoffMs, config.getLong("metadata.max.age.ms"));
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"));
            this.metadata.update(Cluster.bootstrap(addresses), 0L);
            String metricGrpPrefix = "consumer";
            LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>();
            metricsTags.put("client-id", this.clientId);
            ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(config.values());
            NetworkClient netClient = new NetworkClient((Selectable)new Selector(config.getLong("connections.max.idle.ms"), this.metrics, this.time, metricGrpPrefix, metricsTags, channelBuilder), this.metadata, this.clientId, 100, (long)config.getLong("reconnect.backoff.ms"), (int)config.getInt("send.buffer.bytes"), (int)config.getInt("receive.buffer.bytes"), (int)config.getInt("request.timeout.ms"), this.time);
            this.client = new ConsumerNetworkClient(netClient, this.metadata, this.time, this.retryBackoffMs);
            OffsetResetStrategy offsetResetStrategy = OffsetResetStrategy.valueOf(config.getString("auto.offset.reset").toUpperCase());
            this.subscriptions = new SubscriptionState(offsetResetStrategy);
            List<PartitionAssignor> assignors = config.getConfiguredInstances("partition.assignment.strategy", PartitionAssignor.class);
            this.coordinator = new ConsumerCoordinator(this.client, config.getString("group.id"), config.getInt("session.timeout.ms"), config.getInt("heartbeat.interval.ms"), assignors, this.metadata, this.subscriptions, this.metrics, metricGrpPrefix, metricsTags, this.time, this.retryBackoffMs, new ConsumerCoordinator.DefaultOffsetCommitCallback(), config.getBoolean("enable.auto.commit"), config.getLong("auto.commit.interval.ms"));
            if (keyDeserializer == null) {
                this.keyDeserializer = config.getConfiguredInstance("key.deserializer", Deserializer.class);
                this.keyDeserializer.configure(config.originals(), true);
            } else {
                config.ignore("key.deserializer");
                this.keyDeserializer = keyDeserializer;
            }
            if (valueDeserializer == null) {
                this.valueDeserializer = config.getConfiguredInstance("value.deserializer", Deserializer.class);
                this.valueDeserializer.configure(config.originals(), false);
            } else {
                config.ignore("value.deserializer");
                this.valueDeserializer = valueDeserializer;
            }
            this.fetcher = new Fetcher<K, V>(this.client, config.getInt("fetch.min.bytes"), config.getInt("fetch.max.wait.ms"), config.getInt("max.partition.fetch.bytes"), config.getBoolean("check.crcs"), this.keyDeserializer, this.valueDeserializer, this.metadata, this.subscriptions, this.metrics, metricGrpPrefix, metricsTags, this.time, this.retryBackoffMs);
            config.logUnused();
            AppInfoParser.registerAppInfo(JMX_PREFIX, this.clientId);
            log.debug("Kafka consumer created");
        }
        catch (Throwable t) {
            this.close(true);
            throw new KafkaException("Failed to construct kafka consumer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopicPartition> assignment() {
        this.acquire();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(new HashSet<TopicPartition>(this.subscriptions.assignedPartitions()));
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> subscription() {
        this.acquire();
        try {
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.subscriptions.subscription()));
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(List<String> topics, ConsumerRebalanceListener listener) {
        this.acquire();
        try {
            if (topics.isEmpty()) {
                this.unsubscribe();
            } else {
                log.debug("Subscribed to topic(s): {}", (Object)Utils.join(topics, ", "));
                this.subscriptions.subscribe(topics, listener);
                this.metadata.setTopics(this.subscriptions.groupSubscription());
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void subscribe(List<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.acquire();
        try {
            log.debug("Subscribed to pattern: {}", (Object)pattern);
            this.subscriptions.subscribe(pattern, listener);
            this.metadata.needMetadataForAllTopics(true);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        this.acquire();
        try {
            log.debug("Unsubscribed all topics or patterns and assigned partitions");
            this.subscriptions.unsubscribe();
            this.coordinator.maybeLeaveGroup();
            this.metadata.needMetadataForAllTopics(false);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(List<TopicPartition> partitions) {
        this.acquire();
        try {
            log.debug("Subscribed to partition(s): {}", (Object)Utils.join(partitions, ", "));
            this.subscriptions.assignFromUser(partitions);
            HashSet<String> topics = new HashSet<String>();
            for (TopicPartition tp : partitions) {
                topics.add(tp.topic());
            }
            this.metadata.setTopics(topics);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerRecords<K, V> poll(long timeout) {
        this.acquire();
        try {
            long elapsed;
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must not be negative");
            }
            long start = this.time.milliseconds();
            long remaining = timeout;
            do {
                Map<TopicPartition, List<ConsumerRecord<K, V>>> records;
                if ((records = this.pollOnce(remaining)).isEmpty()) continue;
                this.fetcher.initFetches(this.metadata.fetch());
                this.client.poll(0L);
                ConsumerRecords<K, V> consumerRecords = new ConsumerRecords<K, V>(records);
                return consumerRecords;
            } while ((remaining = timeout - (elapsed = this.time.milliseconds() - start)) > 0L);
            ConsumerRecords consumerRecords = ConsumerRecords.empty();
            return consumerRecords;
        }
        finally {
            this.release();
        }
    }

    private Map<TopicPartition, List<ConsumerRecord<K, V>>> pollOnce(long timeout) {
        this.coordinator.ensureCoordinatorKnown();
        if (this.subscriptions.partitionsAutoAssigned()) {
            this.coordinator.ensurePartitionAssignment();
        }
        if (!this.subscriptions.hasAllFetchPositions()) {
            this.updateFetchPositions(this.subscriptions.missingFetchPositions());
        }
        Cluster cluster = this.metadata.fetch();
        Map<TopicPartition, List<ConsumerRecord<K, V>>> records = this.fetcher.fetchedRecords();
        if (!records.isEmpty()) {
            this.client.poll(0L);
            return records;
        }
        this.fetcher.initFetches(cluster);
        this.client.poll(timeout);
        return this.fetcher.fetchedRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSync() {
        this.acquire();
        try {
            this.commitSync(this.subscriptions.allConsumed());
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.acquire();
        try {
            this.coordinator.commitOffsetsSync(offsets);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void commitAsync() {
        this.commitAsync(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        this.acquire();
        try {
            this.commitAsync(this.subscriptions.allConsumed(), callback);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.acquire();
        try {
            log.debug("Committing offsets: {} ", offsets);
            this.coordinator.commitOffsetsAsync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), callback);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(TopicPartition partition, long offset) {
        this.acquire();
        try {
            log.debug("Seeking to offset {} for partition {}", (Object)offset, (Object)partition);
            this.subscriptions.seek(partition, offset);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekToBeginning(TopicPartition ... partitions) {
        this.acquire();
        try {
            Collection<TopicPartition> parts = partitions.length == 0 ? this.subscriptions.assignedPartitions() : Arrays.asList(partitions);
            for (TopicPartition tp : parts) {
                log.debug("Seeking to beginning of partition {}", (Object)tp);
                this.subscriptions.needOffsetReset(tp, OffsetResetStrategy.EARLIEST);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekToEnd(TopicPartition ... partitions) {
        this.acquire();
        try {
            Collection<TopicPartition> parts = partitions.length == 0 ? this.subscriptions.assignedPartitions() : Arrays.asList(partitions);
            for (TopicPartition tp : parts) {
                log.debug("Seeking to end of partition {}", (Object)tp);
                this.subscriptions.needOffsetReset(tp, OffsetResetStrategy.LATEST);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(TopicPartition partition) {
        this.acquire();
        try {
            if (!this.subscriptions.isAssigned(partition)) {
                throw new IllegalArgumentException("You can only check the position for partitions assigned to this consumer.");
            }
            Long offset = this.subscriptions.consumed(partition);
            if (offset == null) {
                this.updateFetchPositions(Collections.singleton(partition));
                offset = this.subscriptions.consumed(partition);
            }
            long l = offset;
            return l;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OffsetAndMetadata committed(TopicPartition partition) {
        this.acquire();
        try {
            OffsetAndMetadata committed;
            if (this.subscriptions.isAssigned(partition)) {
                committed = this.subscriptions.committed(partition);
                if (committed == null) {
                    this.coordinator.refreshCommittedOffsetsIfNeeded();
                    committed = this.subscriptions.committed(partition);
                }
            } else {
                Map<TopicPartition, OffsetAndMetadata> offsets = this.coordinator.fetchCommittedOffsets(Collections.singleton(partition));
                committed = offsets.get(partition);
            }
            OffsetAndMetadata offsetAndMetadata = committed;
            return offsetAndMetadata;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        this.acquire();
        try {
            Cluster cluster = this.metadata.fetch();
            List<PartitionInfo> parts = cluster.partitionsForTopic(topic);
            if (parts != null) {
                List<PartitionInfo> list = parts;
                return list;
            }
            Map<String, List<PartitionInfo>> topicMetadata = this.fetcher.getTopicMetadata(Collections.singletonList(topic), this.requestTimeoutMs);
            List<PartitionInfo> list = topicMetadata.get(topic);
            return list;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        this.acquire();
        try {
            Map<String, List<PartitionInfo>> map = this.fetcher.getAllTopicMetadata(this.requestTimeoutMs);
            return map;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(TopicPartition ... partitions) {
        this.acquire();
        try {
            for (TopicPartition partition : partitions) {
                log.debug("Pausing partition {}", (Object)partition);
                this.subscriptions.pause(partition);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(TopicPartition ... partitions) {
        this.acquire();
        try {
            for (TopicPartition partition : partitions) {
                log.debug("Resuming partition {}", (Object)partition);
                this.subscriptions.resume(partition);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.acquire();
        try {
            if (this.closed) {
                return;
            }
            this.close(false);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void wakeup() {
        this.client.wakeup();
    }

    private void close(boolean swallowException) {
        log.trace("Closing the Kafka consumer.");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        this.closed = true;
        ClientUtils.closeQuietly(this.coordinator, "coordinator", firstException);
        ClientUtils.closeQuietly(this.metrics, "consumer metrics", firstException);
        ClientUtils.closeQuietly(this.client, "consumer network client", firstException);
        ClientUtils.closeQuietly(this.keyDeserializer, "consumer key deserializer", firstException);
        ClientUtils.closeQuietly(this.valueDeserializer, "consumer value deserializer", firstException);
        AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId);
        log.debug("The Kafka consumer has closed.");
        if (firstException.get() != null && !swallowException) {
            throw new KafkaException("Failed to close kafka consumer", firstException.get());
        }
    }

    private void updateFetchPositions(Set<TopicPartition> partitions) {
        this.coordinator.refreshCommittedOffsetsIfNeeded();
        this.fetcher.updateFetchPositions(partitions);
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }

    private void acquire() {
        this.ensureNotClosed();
        long threadId = Thread.currentThread().getId();
        if (threadId != this.currentThread.get() && !this.currentThread.compareAndSet(-1L, threadId)) {
            throw new ConcurrentModificationException("KafkaConsumer is not safe for multi-threaded access");
        }
        this.refcount.incrementAndGet();
    }

    private void release() {
        if (this.refcount.decrementAndGet() == 0) {
            this.currentThread.set(-1L);
        }
    }
}

