/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.util.Assert;

class ExitCodeGenerators
implements Iterable<ExitCodeGenerator> {
    private List<ExitCodeGenerator> generators = new ArrayList<ExitCodeGenerator>();

    ExitCodeGenerators() {
    }

    public void addAll(ExitCodeGenerator ... generators) {
        Assert.notNull((Object)generators, (String)"Generators must not be null");
        this.addAll(Arrays.asList(generators));
    }

    public void addAll(Iterable<? extends ExitCodeGenerator> generators) {
        Assert.notNull(generators, (String)"Generators must not be null");
        for (ExitCodeGenerator exitCodeGenerator : generators) {
            this.add(exitCodeGenerator);
        }
    }

    public void add(ExitCodeGenerator generator) {
        Assert.notNull((Object)generator, (String)"Generator must not be null");
        this.generators.add(generator);
    }

    @Override
    public Iterator<ExitCodeGenerator> iterator() {
        return this.generators.iterator();
    }

    public int getExitCode() {
        int exitCode = 0;
        for (ExitCodeGenerator generator : this.generators) {
            try {
                int value = generator.getExitCode();
                if ((value <= 0 || value <= exitCode) && (value >= 0 || value >= exitCode)) continue;
                exitCode = value;
            }
            catch (Exception ex) {
                exitCode = exitCode == 0 ? 1 : exitCode;
                ex.printStackTrace();
            }
        }
        return exitCode;
    }
}

