/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.Banner;
import org.springframework.boot.BeanDefinitionLoader;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.ExitCodeGenerators;
import org.springframework.boot.LoggedExceptionHandler;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.SpringApplicationRunListeners;
import org.springframework.boot.SpringBootBanner;
import org.springframework.boot.StartupInfoLogger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StandardServletEnvironment;

public class SpringApplication {
    public static final String DEFAULT_CONTEXT_CLASS = "org.springframework.context.annotation.AnnotationConfigApplicationContext";
    public static final String DEFAULT_WEB_CONTEXT_CLASS = "org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext";
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"javax.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    public static final String BANNER_LOCATION_PROPERTY_VALUE = "banner.txt";
    public static final String BANNER_LOCATION_PROPERTY = "banner.location";
    private static final String CONFIGURABLE_WEB_ENVIRONMENT_CLASS = "org.springframework.web.context.ConfigurableWebEnvironment";
    private static final String SYSTEM_PROPERTY_JAVA_AWT_HEADLESS = "java.awt.headless";
    private static final Banner DEFAULT_BANNER = new SpringBootBanner();
    private static final Set<String> SERVLET_ENVIRONMENT_SOURCE_NAMES;
    private final Log log = LogFactory.getLog(this.getClass());
    private final Set<Object> sources = new LinkedHashSet<Object>();
    private Class<?> mainApplicationClass;
    private Banner.Mode bannerMode = Banner.Mode.CONSOLE;
    private boolean logStartupInfo = true;
    private boolean addCommandLineProperties = true;
    private Banner banner;
    private ResourceLoader resourceLoader;
    private BeanNameGenerator beanNameGenerator;
    private ConfigurableEnvironment environment;
    private Class<? extends ConfigurableApplicationContext> applicationContextClass;
    private boolean webEnvironment;
    private boolean headless = true;
    private boolean registerShutdownHook = true;
    private List<ApplicationContextInitializer<?>> initializers;
    private List<ApplicationListener<?>> listeners;
    private Map<String, Object> defaultProperties;
    private Set<String> additionalProfiles = new HashSet<String>();

    public SpringApplication(Object ... sources) {
        this.initialize(sources);
    }

    public SpringApplication(ResourceLoader resourceLoader, Object ... sources) {
        this.resourceLoader = resourceLoader;
        this.initialize(sources);
    }

    private void initialize(Object[] sources) {
        if (sources != null && sources.length > 0) {
            this.sources.addAll(Arrays.asList(sources));
        }
        this.webEnvironment = this.deduceWebEnvironment();
        this.setInitializers(this.getSpringFactoriesInstances(ApplicationContextInitializer.class));
        this.setListeners(this.getSpringFactoriesInstances(ApplicationListener.class));
        this.mainApplicationClass = this.deduceMainApplicationClass();
    }

    private boolean deduceWebEnvironment() {
        for (String className : WEB_ENVIRONMENT_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return false;
        }
        return true;
    }

    private Class<?> deduceMainApplicationClass() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                if (!"main".equals(stackTraceElement.getMethodName())) continue;
                return Class.forName(stackTraceElement.getClassName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public ConfigurableApplicationContext run(String ... args) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ConfigurableApplicationContext context = null;
        this.configureHeadlessProperty();
        SpringApplicationRunListeners listeners = this.getRunListeners(args);
        listeners.started();
        try {
            context = this.doRun(listeners, args);
            stopWatch.stop();
            if (this.logStartupInfo) {
                new StartupInfoLogger(this.mainApplicationClass).logStarted(this.getApplicationLog(), stopWatch);
            }
            return context;
        }
        catch (Throwable ex) {
            this.handleRunFailure(context, listeners, ex);
            throw new IllegalStateException(ex);
        }
    }

    private ConfigurableApplicationContext doRun(SpringApplicationRunListeners listeners, String ... args) {
        ConfigurableEnvironment environment = this.getOrCreateEnvironment();
        this.configureEnvironment(environment, args);
        listeners.environmentPrepared(environment);
        if (this.isWebEnvironment(environment) && !this.webEnvironment) {
            environment = this.convertToStandardEnvironment(environment);
        }
        if (this.bannerMode != Banner.Mode.OFF) {
            this.printBanner((Environment)environment);
        }
        ConfigurableApplicationContext context = this.createApplicationContext();
        context.setEnvironment(environment);
        this.postProcessApplicationContext(context);
        this.applyInitializers(context);
        listeners.contextPrepared(context);
        if (this.logStartupInfo) {
            this.logStartupInfo(context.getParent() == null);
            this.logStartupProfileInfo(context);
        }
        DefaultApplicationArguments applicationArguments = new DefaultApplicationArguments(args);
        context.getBeanFactory().registerSingleton("springApplicationArguments", (Object)applicationArguments);
        Set<Object> sources = this.getSources();
        Assert.notEmpty(sources, (String)"Sources must not be empty");
        this.load((ApplicationContext)context, sources.toArray(new Object[sources.size()]));
        listeners.contextLoaded(context);
        this.refresh((ApplicationContext)context);
        if (this.registerShutdownHook) {
            try {
                context.registerShutdownHook();
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        this.afterRefresh(context, applicationArguments);
        listeners.finished(context, null);
        return context;
    }

    private void configureHeadlessProperty() {
        System.setProperty(SYSTEM_PROPERTY_JAVA_AWT_HEADLESS, System.getProperty(SYSTEM_PROPERTY_JAVA_AWT_HEADLESS, Boolean.toString(this.headless)));
    }

    private SpringApplicationRunListeners getRunListeners(String[] args) {
        Class[] types = new Class[]{SpringApplication.class, String[].class};
        return new SpringApplicationRunListeners(this.log, this.getSpringFactoriesInstances(SpringApplicationRunListener.class, types, this, args));
    }

    private <T> Collection<? extends T> getSpringFactoriesInstances(Class<T> type) {
        return this.getSpringFactoriesInstances(type, new Class[0], new Object[0]);
    }

    private <T> Collection<? extends T> getSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, Object ... args) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<String> names = new LinkedHashSet<String>(SpringFactoriesLoader.loadFactoryNames(type, (ClassLoader)classLoader));
        List<T> instances = this.createSpringFactoriesInstances(type, parameterTypes, classLoader, args, names);
        AnnotationAwareOrderComparator.sort(instances);
        return instances;
    }

    private <T> List<T> createSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, ClassLoader classLoader, Object[] args, Set<String> names) {
        ArrayList instances = new ArrayList(names.size());
        for (String name : names) {
            try {
                Class instanceClass = ClassUtils.forName((String)name, (ClassLoader)classLoader);
                Assert.isAssignable(type, (Class)instanceClass);
                Constructor constructor = instanceClass.getConstructor(parameterTypes);
                Object instance = constructor.newInstance(args);
                instances.add(instance);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Cannot instantiate " + type + " : " + name, ex);
            }
        }
        return instances;
    }

    private ConfigurableEnvironment getOrCreateEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        if (this.webEnvironment) {
            return new StandardServletEnvironment();
        }
        return new StandardEnvironment();
    }

    protected void configureEnvironment(ConfigurableEnvironment environment, String[] args) {
        this.configurePropertySources(environment, args);
        this.configureProfiles(environment, args);
    }

    private boolean isWebEnvironment(ConfigurableEnvironment environment) {
        try {
            Class webEnvironmentClass = ClassUtils.forName((String)CONFIGURABLE_WEB_ENVIRONMENT_CLASS, (ClassLoader)this.getClassLoader());
            return webEnvironmentClass.isInstance(environment);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private ConfigurableEnvironment convertToStandardEnvironment(ConfigurableEnvironment environment) {
        StandardEnvironment result = new StandardEnvironment();
        this.removeAllPropertySources(result.getPropertySources());
        result.setActiveProfiles(environment.getActiveProfiles());
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (SERVLET_ENVIRONMENT_SOURCE_NAMES.contains(propertySource.getName())) continue;
            result.getPropertySources().addLast(propertySource);
        }
        return result;
    }

    private void removeAllPropertySources(MutablePropertySources propertySources) {
        HashSet<String> names = new HashSet<String>();
        for (PropertySource propertySource : propertySources) {
            names.add(propertySource.getName());
        }
        for (String name : names) {
            propertySources.remove(name);
        }
    }

    protected void configurePropertySources(ConfigurableEnvironment environment, String[] args) {
        MutablePropertySources sources = environment.getPropertySources();
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            sources.addLast((PropertySource)new MapPropertySource("defaultProperties", this.defaultProperties));
        }
        if (this.addCommandLineProperties && args.length > 0) {
            String name = "commandLineArgs";
            if (sources.contains(name)) {
                PropertySource source = sources.get(name);
                CompositePropertySource composite = new CompositePropertySource(name);
                composite.addPropertySource((PropertySource)new SimpleCommandLinePropertySource(name + "-" + args.hashCode(), args));
                composite.addPropertySource(source);
                sources.replace(name, (PropertySource)composite);
            } else {
                sources.addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
            }
        }
    }

    protected void configureProfiles(ConfigurableEnvironment environment, String[] args) {
        environment.getActiveProfiles();
        LinkedHashSet<String> profiles = new LinkedHashSet<String>(this.additionalProfiles);
        profiles.addAll(Arrays.asList(environment.getActiveProfiles()));
        environment.setActiveProfiles(profiles.toArray(new String[profiles.size()]));
    }

    protected void printBanner(Environment environment) {
        Banner selectedBanner = this.selectBanner(environment);
        if (this.bannerMode == Banner.Mode.LOG) {
            try {
                this.log.info((Object)this.createStringFromBanner(selectedBanner, environment));
            }
            catch (UnsupportedEncodingException ex) {
                this.log.warn((Object)"Failed to create String for banner", (Throwable)ex);
            }
        } else {
            selectedBanner.printBanner(environment, this.mainApplicationClass, System.out);
        }
    }

    private Banner selectBanner(Environment environment) {
        String location;
        Object resourceLoader = this.resourceLoader != null ? this.resourceLoader : new DefaultResourceLoader(this.getClassLoader());
        Resource resource = resourceLoader.getResource(location = environment.getProperty(BANNER_LOCATION_PROPERTY, BANNER_LOCATION_PROPERTY_VALUE));
        if (resource.exists()) {
            return new ResourceBanner(resource);
        }
        if (this.banner != null) {
            return this.banner;
        }
        return DEFAULT_BANNER;
    }

    private String createStringFromBanner(Banner banner, Environment environment) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        banner.printBanner(environment, this.mainApplicationClass, new PrintStream(baos));
        String charset = environment.getProperty("banner.charset", "UTF-8");
        return baos.toString(charset);
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        Class<Object> contextClass = this.applicationContextClass;
        if (contextClass == null) {
            try {
                contextClass = Class.forName(this.webEnvironment ? DEFAULT_WEB_CONTEXT_CLASS : DEFAULT_CONTEXT_CLASS);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable create a default ApplicationContext, please specify an ApplicationContextClass", ex);
            }
        }
        return (ConfigurableApplicationContext)BeanUtils.instantiate(contextClass);
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
        if (this.webEnvironment && context instanceof ConfigurableWebApplicationContext) {
            ConfigurableWebApplicationContext configurableContext = (ConfigurableWebApplicationContext)context;
            if (this.beanNameGenerator != null) {
                configurableContext.getBeanFactory().registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)this.beanNameGenerator);
            }
        }
        if (this.resourceLoader != null) {
            if (context instanceof GenericApplicationContext) {
                ((GenericApplicationContext)context).setResourceLoader(this.resourceLoader);
            }
            if (context instanceof DefaultResourceLoader) {
                ((DefaultResourceLoader)context).setClassLoader(this.resourceLoader.getClassLoader());
            }
        }
    }

    protected void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer<?> initializer : this.getInitializers()) {
            Class requiredType = GenericTypeResolver.resolveTypeArgument(initializer.getClass(), ApplicationContextInitializer.class);
            Assert.isInstanceOf((Class)requiredType, (Object)context, (String)"Unable to call initializer.");
            initializer.initialize(context);
        }
    }

    protected void logStartupInfo(boolean isRoot) {
        if (isRoot) {
            new StartupInfoLogger(this.mainApplicationClass).logStarting(this.getApplicationLog());
        }
    }

    protected void logStartupProfileInfo(ConfigurableApplicationContext context) {
        Log log = this.getApplicationLog();
        if (log.isInfoEnabled()) {
            Object[] activeProfiles = context.getEnvironment().getActiveProfiles();
            if (ObjectUtils.isEmpty((Object[])activeProfiles)) {
                Object[] defaultProfiles = context.getEnvironment().getDefaultProfiles();
                log.info((Object)("No active profile set, falling back to default profiles: " + StringUtils.arrayToCommaDelimitedString((Object[])defaultProfiles)));
            } else {
                log.info((Object)("The following profiles are active: " + StringUtils.arrayToCommaDelimitedString((Object[])activeProfiles)));
            }
        }
    }

    protected Log getApplicationLog() {
        if (this.mainApplicationClass == null) {
            return this.log;
        }
        return LogFactory.getLog(this.mainApplicationClass);
    }

    protected void load(ApplicationContext context, Object[] sources) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading source " + StringUtils.arrayToCommaDelimitedString((Object[])sources)));
        }
        BeanDefinitionLoader loader = this.createBeanDefinitionLoader(this.getBeanDefinitionRegistry(context), sources);
        if (this.beanNameGenerator != null) {
            loader.setBeanNameGenerator(this.beanNameGenerator);
        }
        if (this.resourceLoader != null) {
            loader.setResourceLoader(this.resourceLoader);
        }
        if (this.environment != null) {
            loader.setEnvironment(this.environment);
        }
        loader.load();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected BeanDefinitionLoader createBeanDefinitionLoader(BeanDefinitionRegistry registry, Object[] sources) {
        return new BeanDefinitionLoader(registry, sources);
    }

    protected void refresh(ApplicationContext applicationContext) {
        Assert.isInstanceOf(AbstractApplicationContext.class, (Object)applicationContext);
        ((AbstractApplicationContext)applicationContext).refresh();
    }

    protected void afterRefresh(ConfigurableApplicationContext context, ApplicationArguments args) {
        this.afterRefresh(context, args.getSourceArgs());
        this.callRunners((ApplicationContext)context, args);
    }

    private void callRunners(ApplicationContext context, ApplicationArguments args) {
        ArrayList runners = new ArrayList();
        runners.addAll(context.getBeansOfType(ApplicationRunner.class).values());
        runners.addAll(context.getBeansOfType(CommandLineRunner.class).values());
        AnnotationAwareOrderComparator.sort(runners);
        for (Object runner : new LinkedHashSet(runners)) {
            if (runner instanceof ApplicationRunner) {
                this.callRunner((ApplicationRunner)runner, args);
            }
            if (!(runner instanceof CommandLineRunner)) continue;
            this.callRunner((CommandLineRunner)runner, args);
        }
    }

    private void callRunner(ApplicationRunner runner, ApplicationArguments args) {
        try {
            runner.run(args);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to execute ApplicationRunner", ex);
        }
    }

    private void callRunner(CommandLineRunner runner, ApplicationArguments args) {
        try {
            runner.run(args.getSourceArgs());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to execute CommandLineRunner", ex);
        }
    }

    @Deprecated
    protected void afterRefresh(ConfigurableApplicationContext context, String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRunFailure(ConfigurableApplicationContext context, SpringApplicationRunListeners listeners, Throwable exception) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)"Application startup failed", exception);
            this.registerLoggedException(exception);
        }
        try {
            try {
                listeners.finished(context, exception);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Unable to close ApplicationContext", (Throwable)ex);
        }
        ReflectionUtils.rethrowRuntimeException((Throwable)exception);
    }

    protected void registerLoggedException(Throwable exception) {
        Thread currentThread = Thread.currentThread();
        if (("main".equals(currentThread.getName()) || "restartedMain".equals(currentThread.getName())) && "main".equals(currentThread.getThreadGroup().getName())) {
            LoggedExceptionHandler.forCurrentThread().register(exception);
        }
    }

    public void setMainApplicationClass(Class<?> mainApplicationClass) {
        this.mainApplicationClass = mainApplicationClass;
    }

    public void setWebEnvironment(boolean webEnvironment) {
        this.webEnvironment = webEnvironment;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
    }

    public void setBanner(Banner banner) {
        this.banner = banner;
    }

    @Deprecated
    public void setShowBanner(boolean showBanner) {
        this.setBannerMode(showBanner ? Banner.Mode.CONSOLE : Banner.Mode.OFF);
    }

    public void setBannerMode(Banner.Mode bannerMode) {
        this.bannerMode = bannerMode;
    }

    public void setLogStartupInfo(boolean logStartupInfo) {
        this.logStartupInfo = logStartupInfo;
    }

    public void setAddCommandLineProperties(boolean addCommandLineProperties) {
        this.addCommandLineProperties = addCommandLineProperties;
    }

    public void setDefaultProperties(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = new HashMap<String, Object>();
        for (Object key : Collections.list(defaultProperties.propertyNames())) {
            this.defaultProperties.put((String)key, defaultProperties.get(key));
        }
    }

    public void setAdditionalProfiles(String ... profiles) {
        this.additionalProfiles = new LinkedHashSet<String>(Arrays.asList(profiles));
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public Set<Object> getSources() {
        return this.sources;
    }

    public void setSources(Set<Object> sources) {
        Assert.notNull(sources, (String)"Sources must not be null");
        this.sources.addAll(sources);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContextClass(Class<? extends ConfigurableApplicationContext> applicationContextClass) {
        this.applicationContextClass = applicationContextClass;
        if (!this.isWebApplicationContext(applicationContextClass)) {
            this.webEnvironment = false;
        }
    }

    private boolean isWebApplicationContext(Class<?> applicationContextClass) {
        try {
            return WebApplicationContext.class.isAssignableFrom(applicationContextClass);
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
    }

    public void setInitializers(Collection<? extends ApplicationContextInitializer<?>> initializers) {
        this.initializers = new ArrayList();
        this.initializers.addAll(initializers);
    }

    public void addInitializers(ApplicationContextInitializer<?> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public Set<ApplicationContextInitializer<?>> getInitializers() {
        return SpringApplication.asUnmodifiableOrderedSet(this.initializers);
    }

    public void setListeners(Collection<? extends ApplicationListener<?>> listeners) {
        this.listeners = new ArrayList();
        this.listeners.addAll(listeners);
    }

    public void addListeners(ApplicationListener<?> ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    public Set<ApplicationListener<?>> getListeners() {
        return SpringApplication.asUnmodifiableOrderedSet(this.listeners);
    }

    public static ConfigurableApplicationContext run(Object source, String ... args) {
        return SpringApplication.run(new Object[]{source}, args);
    }

    public static ConfigurableApplicationContext run(Object[] sources, String[] args) {
        return new SpringApplication(sources).run(args);
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(new Object[0], args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exit(ApplicationContext context, ExitCodeGenerator ... exitCodeGenerators) {
        int exitCode = 0;
        try {
            try {
                ExitCodeGenerators generators = new ExitCodeGenerators();
                Collection beans = context.getBeansOfType(ExitCodeGenerator.class).values();
                generators.addAll(exitCodeGenerators);
                generators.addAll(beans);
                exitCode = generators.getExitCode();
            }
            finally {
                SpringApplication.close(context);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = exitCode == 0 ? 1 : exitCode;
        }
        return exitCode;
    }

    private static void close(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext closable = (ConfigurableApplicationContext)context;
            closable.close();
        }
    }

    private static <E> Set<E> asUnmodifiableOrderedSet(Collection<E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(elements);
        Collections.sort(list, AnnotationAwareOrderComparator.INSTANCE);
        return new LinkedHashSet(list);
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add("servletContextInitParams");
        names.add("servletConfigInitParams");
        names.add("jndiProperties");
        SERVLET_ENVIRONMENT_SOURCE_NAMES = Collections.unmodifiableSet(names);
    }
}

