@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  nakadi startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and NAKADI_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\nakadi-1.0.0.jar;%APP_HOME%\lib\spring-boot-starter-web-1.3.1.RELEASE.jar;%APP_HOME%\lib\spring-security-oauth2-2.0.8.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-security-1.2.5.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-actuator-1.3.1.RELEASE.jar;%APP_HOME%\lib\zmon-actuator-0.9.3.jar;%APP_HOME%\lib\spring-boot-starter-jdbc-1.3.1.RELEASE.jar;%APP_HOME%\lib\postgresql-9.4.1207.jar;%APP_HOME%\lib\httpclient-4.5.1.jar;%APP_HOME%\lib\stups-spring-oauth2-server-1.0.10.jar;%APP_HOME%\lib\jackson-datatype-problem-0.5.0.jar;%APP_HOME%\lib\problem-0.5.0.jar;%APP_HOME%\lib\problem-spring-web-0.5.0.jar;%APP_HOME%\lib\guava-19.0.jar;%APP_HOME%\lib\javax.ws.rs-api-2.0.1.jar;%APP_HOME%\lib\slf4j-log4j12-1.7.14.jar;%APP_HOME%\lib\metrics-core-3.1.2.jar;%APP_HOME%\lib\metrics-spring-3.1.2.jar;%APP_HOME%\lib\metrics-servlets-3.1.2.jar;%APP_HOME%\lib\metrics-jvm-3.1.2.jar;%APP_HOME%\lib\commons-lang3-3.4.jar;%APP_HOME%\lib\kafka-clients-0.9.0.0.jar;%APP_HOME%\lib\kafka_2.11-0.9.0.0.jar;%APP_HOME%\lib\curator-framework-2.9.1.jar;%APP_HOME%\lib\curator-recipes-2.9.1.jar;%APP_HOME%\lib\org.everit.json.schema-1.3.0.jar;%APP_HOME%\lib\jackson-datatype-json-org-2.4.0.jar;%APP_HOME%\lib\jackson-datatype-joda-2.4.0.jar;%APP_HOME%\lib\spring-boot-starter-1.3.1.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-tomcat-1.3.1.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-validation-1.3.1.RELEASE.jar;%APP_HOME%\lib\jackson-databind-2.6.4.jar;%APP_HOME%\lib\spring-security-core-3.2.8.RELEASE.jar;%APP_HOME%\lib\spring-security-config-3.2.8.RELEASE.jar;%APP_HOME%\lib\spring-security-web-3.2.8.RELEASE.jar;%APP_HOME%\lib\jackson-mapper-asl-1.9.13.jar;%APP_HOME%\lib\spring-boot-actuator-1.3.1.RELEASE.jar;%APP_HOME%\lib\tomcat-jdbc-8.0.30.jar;%APP_HOME%\lib\spring-jdbc-4.2.4.RELEASE.jar;%APP_HOME%\lib\httpcore-4.4.3.jar;%APP_HOME%\lib\stups-spring-oauth2-common-1.0.10.jar;%APP_HOME%\lib\jsr305-3.0.0.jar;%APP_HOME%\lib\gag-1.0.1.jar;%APP_HOME%\lib\jackson-datatype-jdk8-2.6.1.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\metrics-healthchecks-3.1.2.jar;%APP_HOME%\lib\metrics-annotation-3.1.2.jar;%APP_HOME%\lib\spring-context-support-4.1.6.RELEASE.jar;%APP_HOME%\lib\metrics-json-3.1.2.jar;%APP_HOME%\lib\snappy-java-1.1.1.7.jar;%APP_HOME%\lib\lz4-1.2.0.jar;%APP_HOME%\lib\zkclient-0.7.jar;%APP_HOME%\lib\metrics-core-2.2.0.jar;%APP_HOME%\lib\scala-xml_2.11-1.0.4.jar;%APP_HOME%\lib\scala-library-2.11.7.jar;%APP_HOME%\lib\scala-parser-combinators_2.11-1.0.4.jar;%APP_HOME%\lib\jopt-simple-3.2.jar;%APP_HOME%\lib\zookeeper-3.4.6.jar;%APP_HOME%\lib\curator-client-2.9.1.jar;%APP_HOME%\lib\json-20160212.jar;%APP_HOME%\lib\commons-validator-1.5.0.jar;%APP_HOME%\lib\joda-time-2.2.jar;%APP_HOME%\lib\tomcat-embed-core-8.0.30.jar;%APP_HOME%\lib\tomcat-embed-el-8.0.30.jar;%APP_HOME%\lib\tomcat-embed-logging-juli-8.0.30.jar;%APP_HOME%\lib\tomcat-embed-websocket-8.0.30.jar;%APP_HOME%\lib\hibernate-validator-5.2.2.Final.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\jackson-core-asl-1.9.13.jar;%APP_HOME%\lib\spring-boot-1.3.1.RELEASE.jar;%APP_HOME%\lib\spring-boot-autoconfigure-1.3.1.RELEASE.jar;%APP_HOME%\lib\tomcat-juli-8.0.30.jar;%APP_HOME%\lib\spring-tx-4.2.4.RELEASE.jar;%APP_HOME%\lib\jline-0.9.94.jar;%APP_HOME%\lib\netty-3.7.0.Final.jar;%APP_HOME%\lib\commons-beanutils-1.9.2.jar;%APP_HOME%\lib\commons-digester-1.8.1.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-collections-3.2.2.jar;%APP_HOME%\lib\jboss-logging-3.2.1.Final.jar;%APP_HOME%\lib\classmate-1.1.0.jar;%APP_HOME%\lib\junit-3.8.1.jar;%APP_HOME%\lib\spring-web-4.2.4.RELEASE.jar;%APP_HOME%\lib\spring-webmvc-4.2.4.RELEASE.jar;%APP_HOME%\lib\spring-beans-4.2.4.RELEASE.jar;%APP_HOME%\lib\spring-core-4.2.4.RELEASE.jar;%APP_HOME%\lib\spring-context-4.2.4.RELEASE.jar;%APP_HOME%\lib\snakeyaml-1.16.jar;%APP_HOME%\lib\spring-expression-4.2.4.RELEASE.jar;%APP_HOME%\lib\spring-aop-4.2.4.RELEASE.jar;%APP_HOME%\lib\commons-codec-1.9.jar;%APP_HOME%\lib\slf4j-api-1.7.14.jar;%APP_HOME%\lib\jackson-annotations-2.6.0.jar;%APP_HOME%\lib\jackson-core-2.6.4.jar

@rem Execute nakadi
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %NAKADI_OPTS%  -classpath "%CLASSPATH%" org.zalando.nakadi.Application %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable NAKADI_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%NAKADI_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
