/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.flowid.autoconfigure;

import io.opentracing.Tracer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.http.client.HttpClient;
import org.apiguardian.api.API;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zalando.opentracing.flowid.Flow;
import org.zalando.opentracing.flowid.httpclient.FlowHttpRequestInterceptor;
import org.zalando.opentracing.flowid.servlet.FlowFilter;

@API(status=API.Status.STABLE)
@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration", "org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration", "io.opentracing.contrib.spring.web.starter.ServerTracingAutoConfiguration"})
public class OpenTracingFlowIdAutoConfiguration {
    @API(status=API.Status.INTERNAL)
    @Bean
    public Flow flow(Tracer tracer) {
        return Flow.create((Tracer)tracer);
    }

    @API(status=API.Status.INTERNAL)
    @Configuration
    @ConditionalOnClass(value={Filter.class, FilterRegistrationBean.class})
    @ConditionalOnWebApplication
    @ConditionalOnProperty(name={"opentracing.flowid.filter.enabled"}, havingValue="true", matchIfMissing=true)
    static class OpenTracingFlowIdWebMvcAutoConfiguration {
        public static final String FILTER_NAME = "flowFilter";

        OpenTracingFlowIdWebMvcAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"flowFilter"})
        public FilterRegistrationBean flowFilter(Flow flow) {
            FlowFilter filter = new FlowFilter(flow);
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
            registration.setName(FILTER_NAME);
            registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
            registration.setOrder(-2147483647);
            return registration;
        }
    }

    @API(status=API.Status.INTERNAL)
    @Configuration
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnMissingBean(value={FlowHttpRequestInterceptor.class})
    @ConditionalOnProperty(name={"opentracing.flowid.httpclient.enabled"}, havingValue="true", matchIfMissing=true)
    static class OpenTracingFlowIdHttpClientAutoConfiguration {
        OpenTracingFlowIdHttpClientAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={FlowHttpRequestInterceptor.class})
        public FlowHttpRequestInterceptor flowHttpRequestInterceptor(Flow flow) {
            return new FlowHttpRequestInterceptor(flow);
        }
    }
}

