/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.flowid.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;
import org.zalando.opentracing.flowid.Flow;
import org.zalando.opentracing.flowid.servlet.HttpFilter;

@API(status=API.Status.STABLE)
public final class FlowFilter
implements HttpFilter {
    private final Flow flow;

    public FlowFilter(Flow flow) {
        this.flow = flow;
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.flow.readFrom(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0));
        if (this.isLegacyRequest(request)) {
            this.flow.writeTo((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isLegacyRequest(HttpServletRequest request) {
        return request.getHeader("X-Flow-ID") != null;
    }
}

