/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.flowid;

import io.opentracing.Span;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.zalando.opentracing.flowid.Extractor;
import org.zalando.opentracing.flowid.FlowId;

final class CompositeExtractor
implements Extractor {
    private final Collection<Extractor> extractors;

    CompositeExtractor(Extractor ... extractors) {
        this(Arrays.asList(extractors));
    }

    @Override
    public Optional<FlowId> extract(Span span, UnaryOperator<String> reader) {
        return this.extractors.stream().map(strategy -> strategy.extract(span, reader)).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }

    @Generated
    public CompositeExtractor(Collection<Extractor> extractors) {
        this.extractors = extractors;
    }
}

