/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.flowid;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.opentracing.flowid.BaggageExtractor;
import org.zalando.opentracing.flowid.CompositeExtractor;
import org.zalando.opentracing.flowid.Extractor;
import org.zalando.opentracing.flowid.Flow;
import org.zalando.opentracing.flowid.FlowId;
import org.zalando.opentracing.flowid.FlowListener;
import org.zalando.opentracing.flowid.HeaderExtractor;
import org.zalando.opentracing.flowid.TraceExtractor;

final class DefaultFlow
implements Flow {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFlow.class);
    private final Extractor extractor = new CompositeExtractor(new BaggageExtractor(), new HeaderExtractor(), new TraceExtractor());
    private final Tracer tracer;
    private final FlowListener listener;

    @Override
    public void readFrom(UnaryOperator<String> reader) {
        Optional<String> laterId;
        Span span = this.activeSpan();
        Optional<FlowId> now = this.extractor.extract(span, reader);
        Optional<FlowId> later = this.extractor.extract(span);
        Optional<String> nowId = now.map(FlowId::getValue);
        if (nowId.equals(laterId = later.map(FlowId::getValue))) {
            later.ifPresent(flowId -> this.listener.onRead(span, (FlowId)flowId));
        } else {
            now.ifPresent(flowId -> {
                this.bag(span, (FlowId)flowId);
                this.listener.onRead(span, (FlowId)flowId);
            });
        }
    }

    private void bag(Span span, FlowId flowId) {
        span.setBaggageItem("flow_id", flowId.getValue());
    }

    @Override
    public String currentId() {
        return this.extractor.extract(this.activeSpan()).map(FlowId::getValue).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void writeTo(BiConsumer<String, String> writer) {
        writer.accept("X-Flow-ID", this.currentId());
    }

    @Override
    public <T> T write(BiFunction<String, String, T> writer) {
        return writer.apply("X-Flow-ID", this.currentId());
    }

    private Span activeSpan() {
        Span span = this.tracer.activeSpan();
        if (span == null) {
            throw new IllegalStateException("No active span found");
        }
        return span;
    }

    @Generated
    public DefaultFlow(Tracer tracer, FlowListener listener) {
        this.tracer = tracer;
        this.listener = listener;
    }
}

