/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.flowid;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.opentracing.flowid.BaggageExtractor;
import org.zalando.opentracing.flowid.CompositeExtractor;
import org.zalando.opentracing.flowid.Extractor;
import org.zalando.opentracing.flowid.Flow;
import org.zalando.opentracing.flowid.FlowId;
import org.zalando.opentracing.flowid.FlowListener;
import org.zalando.opentracing.flowid.HeaderExtractor;
import org.zalando.opentracing.flowid.TraceExtractor;

final class DefaultFlow
implements Flow {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFlow.class);
    private static final Logger LOG = LoggerFactory.getLogger((String)DefaultFlow.class.getName());
    private final Extractor extractor = new CompositeExtractor(new BaggageExtractor(), new HeaderExtractor(), new TraceExtractor());
    private final Tracer tracer;
    private final FlowListener listener;

    @Override
    public void readFrom(UnaryOperator<String> reader) {
        this.activeSpan().ifPresent(span -> {
            Optional<String> laterId;
            Optional<FlowId> now = this.extractor.extract((Span)span, reader);
            Optional<FlowId> later = this.extractor.extract((Span)span);
            Optional<String> nowId = now.map(FlowId::getValue);
            if (nowId.equals(laterId = later.map(FlowId::getValue))) {
                later.ifPresent(flowId -> this.listener.onRead((Span)span, (FlowId)flowId));
            } else {
                now.ifPresent(flowId -> {
                    this.bag((Span)span, (FlowId)flowId);
                    this.listener.onRead((Span)span, (FlowId)flowId);
                });
            }
        });
    }

    private void bag(Span span, FlowId flowId) {
        span.setBaggageItem("flow_id", flowId.getValue());
    }

    @Override
    public String currentId() {
        return this.activeSpan().flatMap(this.extractor::extract).map(FlowId::getValue).orElse(null);
    }

    @Override
    public void writeTo(BiConsumer<String, String> writer) {
        this.activeSpan().flatMap(this.extractor::extract).map(FlowId::getValue).ifPresent(value -> writer.accept("X-Flow-ID", (String)value));
    }

    @Override
    public <T> T write(BiFunction<String, String, T> writer) {
        String currentId = this.currentId();
        if (currentId != null) {
            return writer.apply("X-Flow-ID", currentId);
        }
        return null;
    }

    private Optional<Span> activeSpan() {
        Span span = this.tracer.activeSpan();
        if (span == null) {
            LOG.warn("No active span found");
        }
        return Optional.ofNullable(span);
    }

    @Generated
    public DefaultFlow(Tracer tracer, FlowListener listener) {
        this.tracer = tracer;
        this.listener = listener;
    }
}

