/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.autoconfigure;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import lombok.Generated;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;

final class ConditionalMethodInterceptor
implements MethodInterceptor {
    private final Object delegate;
    private final Collection<Method> methods;

    public ConditionalMethodInterceptor(Object delegate) {
        this(delegate, Arrays.asList(delegate.getClass().getMethods()));
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = this.find(invocation.getMethod());
        if (method == null) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        return AopUtils.invokeJoinpointUsingReflection((Object)this.delegate, (Method)method, (Object[])arguments);
    }

    @Nullable
    private Method find(Method method) {
        for (Method candidate : this.methods) {
            if (!this.sameName(method, candidate) || !this.sameParameters(method, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private boolean sameName(Method left, Method right) {
        return left.getName().equals(right.getName());
    }

    private boolean sameParameters(Method left, Method right) {
        return Arrays.equals(left.getParameterTypes(), right.getParameterTypes());
    }

    @Generated
    private ConditionalMethodInterceptor(Object delegate, Collection<Method> methods) {
        this.delegate = delegate;
        this.methods = methods;
    }
}

