/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.autoconfigure;

import io.opentracing.Tracer;
import java.util.List;
import javax.sql.DataSource;
import org.apiguardian.api.API;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zalando.opentracing.jdbc.Activation;
import org.zalando.opentracing.jdbc.DataSourceTracer;
import org.zalando.opentracing.jdbc.Lifecycle;
import org.zalando.opentracing.jdbc.NewSpanLifecycle;
import org.zalando.opentracing.jdbc.NoOpActivation;
import org.zalando.opentracing.jdbc.autoconfigure.TracingProcessor;
import org.zalando.opentracing.jdbc.operation.DefaultOperationName;
import org.zalando.opentracing.jdbc.operation.OperationName;
import org.zalando.opentracing.jdbc.operation.StoredProcedureOperationName;
import org.zalando.opentracing.jdbc.span.SpanDecorator;
import org.zalando.opentracing.jdbc.span.StandardSpanDecorator;

@API(status=API.Status.STABLE)
@Configuration
@ConditionalOnBean(value={Tracer.class, DataSource.class})
public class OpenTracingJdbcAutoConfiguration {
    @API(status=API.Status.INTERNAL)
    @Bean
    @ConditionalOnProperty(name={"opentracing.jdbc.enabled"}, havingValue="true", matchIfMissing=true)
    public BeanPostProcessor tracingDataSourceBeanPostProcessor(DataSourceTracer tracer) {
        return new TracingProcessor(tracer);
    }

    @API(status=API.Status.INTERNAL)
    @Configuration
    @ConditionalOnMissingBean(value={DataSourceTracer.class})
    public static class DataSourceTracerConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={OperationName.class})
        public OperationName openTracingJdbcOperationName() {
            return new StoredProcedureOperationName((OperationName)new DefaultOperationName());
        }

        @Bean
        @ConditionalOnMissingBean(value={Lifecycle.class})
        public Lifecycle openTracingJdbcLifecycle() {
            return new NewSpanLifecycle();
        }

        @Bean
        @ConditionalOnMissingBean(value={Activation.class})
        public Activation openTracingJdbcActivation() {
            return new NoOpActivation();
        }

        @Bean
        @ConditionalOnMissingBean(value={SpanDecorator.class})
        public SpanDecorator openTracingJdbcSpanDecorator() {
            return new StandardSpanDecorator();
        }

        @Bean
        public DataSourceTracer dataSourceTracer(Tracer tracer, OperationName operationName, Lifecycle lifecycle, Activation activation, List<SpanDecorator> decorators) {
            return new DataSourceTracer(tracer).withOperationName(operationName).withLifecycle(lifecycle).withActivation(activation).withSpanDecorators(SpanDecorator.composite(decorators), new SpanDecorator[0]);
        }
    }
}

