/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.operation;

import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.opentracing.jdbc.operation.DefaultOperationName;
import org.zalando.opentracing.jdbc.operation.OperationName;

@API(status=API.Status.EXPERIMENTAL)
public final class StoredProcedureOperationName
implements OperationName {
    private final Pattern pattern = Pattern.compile("^SELECT \\* FROM (.+)\\(.*\\)$");
    private final OperationName fallback;

    public StoredProcedureOperationName() {
        this(new DefaultOperationName());
    }

    @Override
    public String generate(Method method, List<String> queries) {
        for (String query : queries) {
            Matcher matcher = this.pattern.matcher(query);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return this.fallback.generate(method, queries);
    }

    @Generated
    public StoredProcedureOperationName(OperationName fallback) {
        this.fallback = fallback;
    }
}

