/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.span;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.zalando.opentracing.jdbc.span.Peer;
import org.zalando.opentracing.jdbc.span.PeerParser;

final class PatternPeerParser
implements PeerParser {
    private final Pattern pattern = Pattern.compile("jdbc:(?:[a-z0-9-]+:)+(?:/{2}|@|)(?<host>(?:\\[.+])|[^:/]+)(?::(?<port>\\d+))?.*");
    private final Pattern ipv4 = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
    private final Pattern ipv6 = Pattern.compile("\\[((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?]");

    PatternPeerParser() {
    }

    @Override
    public Peer parse(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (matcher.find()) {
            return this.createFrom(matcher);
        }
        return Peer.EMPTY;
    }

    private Peer createFrom(Matcher matcher) {
        String host = matcher.group("host");
        String port = matcher.group("port");
        Peer url = Peer.EMPTY;
        return this.withPort(this.withHost(url, host), port);
    }

    private Peer withHost(Peer url, String host) {
        if (this.isIpv4(host)) {
            return url.withIpv4(host);
        }
        if (this.isIpv6(host)) {
            return url.withIpv6(this.removeSquareBrackets(host));
        }
        return url.withHostname(host);
    }

    private boolean isIpv4(String host) {
        return this.ipv4.matcher(host).matches();
    }

    private boolean isIpv6(String host) {
        return this.ipv6.matcher(host).matches();
    }

    private String removeSquareBrackets(String ipv6) {
        return ipv6.substring(1, ipv6.length() - 1);
    }

    private Peer withPort(Peer url, @Nullable String port) {
        if (port == null) {
            return url;
        }
        return url.withPort(Integer.valueOf(port));
    }
}

